/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.statemachine;

import io.openmessaging.storage.dledger.DLedgerEntryPusher;
import io.openmessaging.storage.dledger.DLedgerServer;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.exception.DLedgerException;
import io.openmessaging.storage.dledger.snapshot.SnapshotManager;
import io.openmessaging.storage.dledger.snapshot.SnapshotMeta;
import io.openmessaging.storage.dledger.snapshot.SnapshotReader;
import io.openmessaging.storage.dledger.snapshot.SnapshotStatus;
import io.openmessaging.storage.dledger.snapshot.SnapshotWriter;
import io.openmessaging.storage.dledger.snapshot.hook.LoadSnapshotHook;
import io.openmessaging.storage.dledger.snapshot.hook.SaveSnapshotHook;
import io.openmessaging.storage.dledger.snapshot.hook.SnapshotHook;
import io.openmessaging.storage.dledger.statemachine.CommittedEntryIterator;
import io.openmessaging.storage.dledger.statemachine.StateMachine;
import io.openmessaging.storage.dledger.store.DLedgerStore;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.rocketmq.remoting.common.ServiceThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineCaller
extends ServiceThread {
    private static final long RETRY_ON_COMMITTED_DELAY = 1000L;
    private static Logger logger = LoggerFactory.getLogger(StateMachineCaller.class);
    private final DLedgerStore dLedgerStore;
    private final StateMachine statemachine;
    private final DLedgerEntryPusher entryPusher;
    private final AtomicLong lastAppliedIndex;
    private long lastAppliedTerm;
    private final AtomicLong applyingIndex;
    private final BlockingQueue<ApplyTask> taskQueue;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "RetryOnCommittedScheduledThread");
        }
    });
    private final Function<Long, Boolean> completeEntryCallback;
    private volatile DLedgerException error;
    private SnapshotManager snapshotManager;

    public StateMachineCaller(DLedgerStore dLedgerStore, StateMachine statemachine, DLedgerEntryPusher entryPusher) {
        this.dLedgerStore = dLedgerStore;
        this.statemachine = statemachine;
        this.entryPusher = entryPusher;
        this.lastAppliedIndex = new AtomicLong(-1L);
        this.applyingIndex = new AtomicLong(-1L);
        this.taskQueue = new LinkedBlockingQueue<ApplyTask>(1024);
        this.completeEntryCallback = entryPusher != null ? entryPusher::completeResponseFuture : index -> true;
    }

    private boolean enqueueTask(ApplyTask task) {
        return this.taskQueue.offer(task);
    }

    public StateMachine getStateMachine() {
        return this.statemachine;
    }

    public boolean onCommitted(long committedIndex) {
        ApplyTask task = new ApplyTask();
        task.type = TaskType.COMMITTED;
        task.committedIndex = committedIndex;
        return this.enqueueTask(task);
    }

    public boolean onSnapshotLoad(LoadSnapshotHook loadSnapshotAfter) {
        ApplyTask task = new ApplyTask();
        task.type = TaskType.SNAPSHOT_LOAD;
        task.snapshotHook = loadSnapshotAfter;
        return this.enqueueTask(task);
    }

    public boolean onSnapshotSave(SaveSnapshotHook saveSnapshotAfter) {
        ApplyTask task = new ApplyTask();
        task.type = TaskType.SNAPSHOT_SAVE;
        task.snapshotHook = saveSnapshotAfter;
        return this.enqueueTask(task);
    }

    public void shutdown() {
        super.shutdown();
        this.statemachine.onShutdown();
    }

    public void run() {
        while (!this.isStopped()) {
            try {
                ApplyTask task = this.taskQueue.poll(5L, TimeUnit.SECONDS);
                if (task == null) continue;
                switch (task.type) {
                    case COMMITTED: {
                        this.doCommitted(task.committedIndex);
                        break;
                    }
                    case SNAPSHOT_SAVE: {
                        this.doSnapshotSave((SaveSnapshotHook)task.snapshotHook);
                        break;
                    }
                    case SNAPSHOT_LOAD: {
                        this.doSnapshotLoad((LoadSnapshotHook)task.snapshotHook);
                    }
                }
            }
            catch (InterruptedException e) {
                logger.error("Error happen in {} when pull task from task queue", (Object)this.getServiceName(), (Object)e);
            }
            catch (Throwable e) {
                logger.error("Apply task exception", e);
            }
        }
    }

    private void doCommitted(long committedIndex) {
        if (this.error != null) {
            return;
        }
        if (this.snapshotManager.isLoadingSnapshot()) {
            this.scheduledExecutorService.schedule(() -> {
                try {
                    this.onCommitted(committedIndex);
                    logger.info("Still loading snapshot, retry the commit task later");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }, 1000L, TimeUnit.MILLISECONDS);
            return;
        }
        long lastAppliedIndex = this.lastAppliedIndex.get();
        if (lastAppliedIndex >= committedIndex) {
            return;
        }
        CommittedEntryIterator iter = new CommittedEntryIterator(this.dLedgerStore, committedIndex, this.applyingIndex, lastAppliedIndex, this.completeEntryCallback);
        while (iter.hasNext()) {
            this.statemachine.onApply(iter);
        }
        long lastIndex = iter.getIndex();
        this.lastAppliedIndex.set(lastIndex);
        DLedgerEntry dLedgerEntry = this.dLedgerStore.get(lastIndex);
        if (dLedgerEntry != null) {
            this.lastAppliedTerm = dLedgerEntry.getTerm();
        }
        this.snapshotManager.saveSnapshot(dLedgerEntry);
        if (iter.getCompleteAckNums() == 0 && this.entryPusher != null) {
            this.entryPusher.checkResponseFuturesTimeout(this.lastAppliedIndex.get() + 1L);
        }
    }

    private void doSnapshotLoad(LoadSnapshotHook loadSnapshotAfter) {
        long snapshotTerm;
        SnapshotMeta snapshotMeta;
        SnapshotReader reader = loadSnapshotAfter.getSnapshotReader();
        try {
            snapshotMeta = reader.load();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            loadSnapshotAfter.doCallBack(SnapshotStatus.FAIL);
            return;
        }
        if (snapshotMeta == null) {
            logger.error("Unable to load state machine meta");
            loadSnapshotAfter.doCallBack(SnapshotStatus.FAIL);
            return;
        }
        long snapshotIndex = snapshotMeta.getLastIncludedIndex();
        if (this.lastAppliedCompareToSnapshot(snapshotIndex, snapshotTerm = snapshotMeta.getLastIncludedTerm()) > 0) {
            logger.warn("The snapshot loading is expired");
            loadSnapshotAfter.doCallBack(SnapshotStatus.EXPIRED);
            return;
        }
        try {
            if (!this.statemachine.onSnapshotLoad(reader)) {
                logger.error("Unable to load data from snapshot into state machine");
                loadSnapshotAfter.doCallBack(SnapshotStatus.FAIL);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            loadSnapshotAfter.doCallBack(SnapshotStatus.FAIL);
            return;
        }
        this.lastAppliedIndex.set(snapshotMeta.getLastIncludedIndex());
        this.lastAppliedTerm = snapshotMeta.getLastIncludedTerm();
        loadSnapshotAfter.registerSnapshotMeta(snapshotMeta);
        loadSnapshotAfter.doCallBack(SnapshotStatus.SUCCESS);
    }

    private int lastAppliedCompareToSnapshot(long snapshotIndex, long snapshotTerm) {
        int res = Long.compare(this.lastAppliedTerm, snapshotTerm);
        if (res == 0) {
            return Long.compare(this.lastAppliedIndex.get(), snapshotIndex);
        }
        return res;
    }

    private void doSnapshotSave(SaveSnapshotHook saveSnapshotAfter) {
        DLedgerEntry curEntry = saveSnapshotAfter.getSnapshotEntry();
        saveSnapshotAfter.registerSnapshotMeta(new SnapshotMeta(curEntry.getIndex(), curEntry.getTerm()));
        SnapshotWriter writer = saveSnapshotAfter.getSnapshotWriter();
        if (writer == null) {
            return;
        }
        try {
            if (!this.statemachine.onSnapshotSave(writer)) {
                logger.error("Unable to save snapshot data from state machine");
                saveSnapshotAfter.doCallBack(SnapshotStatus.FAIL);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            saveSnapshotAfter.doCallBack(SnapshotStatus.FAIL);
            return;
        }
        saveSnapshotAfter.doCallBack(SnapshotStatus.SUCCESS);
    }

    public void setError(DLedgerServer server, DLedgerException error) {
        this.error = error;
        if (this.statemachine != null) {
            this.statemachine.onError(error);
        }
        if (server != null) {
            server.shutdown();
        }
    }

    public String getServiceName() {
        return StateMachineCaller.class.getName();
    }

    public Long getLastAppliedIndex() {
        return this.lastAppliedIndex.get();
    }

    public long getLastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    public void registerSnapshotManager(SnapshotManager snapshotManager) {
        this.snapshotManager = snapshotManager;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    public DLedgerStore getdLedgerStore() {
        return this.dLedgerStore;
    }

    private static class ApplyTask {
        TaskType type;
        long committedIndex;
        long term;
        SnapshotHook snapshotHook;

        private ApplyTask() {
        }
    }

    private static enum TaskType {
        COMMITTED,
        SNAPSHOT_SAVE,
        SNAPSHOT_LOAD,
        SHUTDOWN;

    }
}

