/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity.codec.v2;

import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.codec.LogEntryEncoder;
import com.alipay.sofa.jraft.entity.codec.v2.LogEntryV2CodecFactory;
import com.alipay.sofa.jraft.entity.codec.v2.LogOutter;
import com.alipay.sofa.jraft.error.LogEntryCorruptedException;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.alipay.sofa.jraft.util.Requires;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ZeroByteStringHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class V2Encoder
implements LogEntryEncoder {
    public static final V2Encoder INSTANCE = new V2Encoder();

    private static boolean hasPeers(Collection<PeerId> peers) {
        return peers != null && !peers.isEmpty();
    }

    private void encodePeers(LogOutter.PBLogEntry.Builder builder, List<PeerId> peers) {
        int size = peers.size();
        for (int i = 0; i < size; ++i) {
            builder.addPeers(ZeroByteStringHelper.wrap(AsciiStringUtil.unsafeEncode(peers.get(i).toString())));
        }
    }

    private void encodeOldPeers(LogOutter.PBLogEntry.Builder builder, List<PeerId> peers) {
        int size = peers.size();
        for (int i = 0; i < size; ++i) {
            builder.addOldPeers(ZeroByteStringHelper.wrap(AsciiStringUtil.unsafeEncode(peers.get(i).toString())));
        }
    }

    private void encodeLearners(LogOutter.PBLogEntry.Builder builder, List<PeerId> learners) {
        int size = learners.size();
        for (int i = 0; i < size; ++i) {
            builder.addLearners(ZeroByteStringHelper.wrap(AsciiStringUtil.unsafeEncode(learners.get(i).toString())));
        }
    }

    private void encodeOldLearners(LogOutter.PBLogEntry.Builder builder, List<PeerId> learners) {
        int size = learners.size();
        for (int i = 0; i < size; ++i) {
            builder.addOldLearners(ZeroByteStringHelper.wrap(AsciiStringUtil.unsafeEncode(learners.get(i).toString())));
        }
    }

    @Override
    public byte[] encode(LogEntry log) {
        int i;
        List<PeerId> oldLearners;
        List<PeerId> learners;
        List<PeerId> oldPeers;
        Requires.requireNonNull(log, "Null log");
        LogId logId = log.getId();
        LogOutter.PBLogEntry.Builder builder = LogOutter.PBLogEntry.newBuilder().setType(log.getType()).setIndex(logId.getIndex()).setTerm(logId.getTerm());
        List<PeerId> peers = log.getPeers();
        if (V2Encoder.hasPeers(peers)) {
            this.encodePeers(builder, peers);
        }
        if (V2Encoder.hasPeers(oldPeers = log.getOldPeers())) {
            this.encodeOldPeers(builder, oldPeers);
        }
        if (V2Encoder.hasPeers(learners = log.getLearners())) {
            this.encodeLearners(builder, learners);
        }
        if (V2Encoder.hasPeers(oldLearners = log.getOldLearners())) {
            this.encodeOldLearners(builder, oldLearners);
        }
        if (log.hasChecksum()) {
            builder.setChecksum(log.getChecksum());
        }
        builder.setData(log.getData() != null ? ZeroByteStringHelper.wrap(log.getData()) : ByteString.EMPTY);
        LogOutter.PBLogEntry pbLogEntry = builder.build();
        int bodyLen = pbLogEntry.getSerializedSize();
        byte[] ret = new byte[LogEntryV2CodecFactory.HEADER_SIZE + bodyLen];
        for (i = 0; i < LogEntryV2CodecFactory.MAGIC_BYTES.length; ++i) {
            ret[i] = LogEntryV2CodecFactory.MAGIC_BYTES[i];
        }
        ret[i++] = 1;
        while (i < LogEntryV2CodecFactory.HEADER_SIZE) {
            ret[i] = LogEntryV2CodecFactory.RESERVED[i - LogEntryV2CodecFactory.MAGIC_BYTES.length - 1];
            ++i;
        }
        this.writeToByteArray(pbLogEntry, ret, i, bodyLen);
        return ret;
    }

    private void writeToByteArray(LogOutter.PBLogEntry pbLogEntry, byte[] array, int offset, int len) {
        CodedOutputStream output = CodedOutputStream.newInstance((byte[])array, (int)offset, (int)len);
        try {
            pbLogEntry.writeTo(output);
            output.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new LogEntryCorruptedException("Serializing PBLogEntry to a byte array threw an IOException (should never happen).", e);
        }
    }

    private V2Encoder() {
    }
}

