/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class ResourceLimitMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String RESOURCELIMIT_LOG_HIERARCHY = "qpid.message.resourcelimit";
    public static final String ACCEPTED_LOG_HIERARCHY = "qpid.message.resourcelimit.accepted";
    public static final String INFO_LOG_HIERARCHY = "qpid.message.resourcelimit.info";
    public static final String REJECTED_LOG_HIERARCHY = "qpid.message.resourcelimit.rejected";

    public static LogMessage ACCEPTED(CharSequence param1, CharSequence param2, CharSequence param3, CharSequence param4) {
        String rawMessage = MESSAGES.getString("ACCEPTED");
        Object[] messageArguments = new Object[]{param1, param2, param3, param4};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ResourceLimitMessages.ACCEPTED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage INFO(CharSequence param1, CharSequence param2) {
        String rawMessage = MESSAGES.getString("INFO");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ResourceLimitMessages.INFO_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage REJECTED(CharSequence param1, CharSequence param2, CharSequence param3, CharSequence param4) {
        String rawMessage = MESSAGES.getString("REJECTED");
        Object[] messageArguments = new Object[]{param1, param2, param3, param4};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return ResourceLimitMessages.REJECTED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private ResourceLimitMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)RESOURCELIMIT_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)ACCEPTED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)INFO_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)REJECTED_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.ResourceLimit_logmessages", CURRENT_LOCALE);
    }
}

