/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport.mimecontentconverter;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.transport.BBEncoder;
import org.apache.qpid.server.protocol.v0_10.transport.EncoderUtils;

@PluggableService
public class MapToAmqpMapConverter
implements ObjectToMimeContentConverter<Map> {
    public String getType() {
        return this.getMimeType();
    }

    public String getMimeType() {
        return "amqp/map";
    }

    public Class<Map> getObjectClass() {
        return Map.class;
    }

    public int getRank() {
        return 0;
    }

    public boolean isAcceptable(Map map) {
        return EncoderUtils.isEncodable(map);
    }

    public byte[] toMimeContent(Map map) {
        BBEncoder encoder = new BBEncoder(1024);
        encoder.writeMap(map);
        ByteBuffer buf = encoder.buffer();
        int remaining = buf.remaining();
        byte[] data = new byte[remaining];
        buf.get(data);
        return data;
    }
}

