/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.outcome;

import java.util.Objects;
import org.apache.qpid.server.security.limit.ConnectionSlot;
import org.apache.qpid.server.user.connection.limits.logging.ConnectionLimitEventLogger;

public final class AcceptRegistration
implements ConnectionSlot {
    private static final String USER_WITH_COUNT_ON_PORT = "User %s with connection count %d on %s port";
    private final String _message;
    private final String _userId;
    private final ConnectionSlot _slot;

    public static AcceptRegistration newInstance(ConnectionSlot slot, String userId, long currentCount, String port) {
        return new AcceptRegistration(slot, userId, String.format(USER_WITH_COUNT_ON_PORT, userId, currentCount, port));
    }

    private AcceptRegistration(ConnectionSlot slot, String userId, String message) {
        this._slot = Objects.requireNonNull(slot);
        this._userId = Objects.requireNonNull(userId);
        this._message = Objects.requireNonNull(message);
    }

    public ConnectionSlot logMessage(ConnectionLimitEventLogger logger) {
        logger.logAcceptConnection(this._userId, this.getMessage());
        return this._slot;
    }

    public void free() {
        this._slot.free();
    }

    protected String getMessage() {
        return this._message;
    }
}

