/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.serializer.MessageStoreSerializer;

class MessageStoreSerializerFactory
implements MessageStoreSerializer.Factory {
    MessageStoreSerializerFactory() {
    }

    @Override
    public MessageStoreSerializer newInstance() {
        return new QpidServiceLoader().getInstancesByType(MessageStoreSerializer.class).get("v1.0");
    }

    @Override
    public MessageStoreSerializer newInstance(DataInputStream data) throws IOException {
        data.mark(50);
        if (data.read() != 0) {
            throw new IllegalArgumentException("Invalid format for upload");
        }
        int stringLength = data.readInt();
        byte[] stringBytes = new byte[stringLength];
        data.readFully(stringBytes);
        String version = new String(stringBytes, StandardCharsets.UTF_8);
        data.reset();
        Map<String, MessageStoreSerializer> serializerMap = new QpidServiceLoader().getInstancesByType(MessageStoreSerializer.class);
        MessageStoreSerializer serializer = serializerMap.get(version);
        if (serializer == null) {
            throw new IllegalArgumentException("Message store import uses version '" + version + "' which is not supported");
        }
        return serializer;
    }
}

