/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.jvm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import opennlp.tools.commons.Internal;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.util.jvm.StringInterner;

@Internal
@ThreadSafe
class CHMStringDeduplicator
implements StringInterner {
    private final int prob;
    private final Map<String, String> map;

    public CHMStringDeduplicator() {
        this(0.5);
    }

    public CHMStringDeduplicator(double prob) {
        this.prob = (int)(-2.147483648E9 + prob * 4.294967296E9);
        this.map = new ConcurrentHashMap<String, String>();
    }

    @Override
    public String intern(String sample) {
        if (ThreadLocalRandom.current().nextInt() > this.prob) {
            return sample;
        }
        String exist = this.map.putIfAbsent(sample, sample);
        return exist == null ? sample : exist;
    }
}

