/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nar;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.NarComponentTypesResult;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.NarDetailsEntity;

public class ListNarComponentTypes
extends AbstractNiFiCommand<NarComponentTypesResult> {
    public ListNarComponentTypes() {
        super("list-nar-component-types", NarComponentTypesResult.class);
    }

    @Override
    public String getDescription() {
        return "Lists the available component types for a given NAR in the NAR Manager";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.NAR_ID.createOption());
    }

    @Override
    public NarComponentTypesResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String narId = this.getRequiredArg(properties, CommandOption.NAR_ID);
        ControllerClient controllerClient = client.getControllerClient();
        NarDetailsEntity detailsEntity = controllerClient.getNarDetails(narId);
        return new NarComponentTypesResult(this.getResultType(properties), detailsEntity);
    }
}

