/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.ResolvableType;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.AuthorizationManagers;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.authorization.SpringAuthorizationEventPublisher;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;

public final class AuthorizeHttpRequestsConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<AuthorizeHttpRequestsConfigurer<H>, H> {
    private final AuthorizationManagerRequestMatcherRegistry registry;
    private final AuthorizationEventPublisher publisher;
    private final AuthorizationManagerFactory<? super RequestAuthorizationContext> authorizationManagerFactory;
    private ObjectPostProcessor<AuthorizationManager<HttpServletRequest>> postProcessor = ObjectPostProcessor.identity();

    public AuthorizeHttpRequestsConfigurer(ApplicationContext context) {
        this.registry = new AuthorizationManagerRequestMatcherRegistry(context);
        this.publisher = context.getBeanNamesForType(AuthorizationEventPublisher.class).length > 0 ? (AuthorizationEventPublisher)context.getBean(AuthorizationEventPublisher.class) : new SpringAuthorizationEventPublisher((ApplicationEventPublisher)context);
        this.authorizationManagerFactory = this.getAuthorizationManagerFactory(context);
        ResolvableType type = ResolvableType.forClassWithGenerics(ObjectPostProcessor.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(AuthorizationManager.class, (Class[])new Class[]{HttpServletRequest.class})});
        ObjectProvider provider = context.getBeanProvider(type);
        provider.ifUnique(postProcessor -> {
            this.postProcessor = postProcessor;
        });
    }

    private AuthorizationManagerFactory<? super RequestAuthorizationContext> getAuthorizationManagerFactory(ApplicationContext context) {
        ResolvableType authorizationManagerFactoryType = ResolvableType.forClassWithGenerics(AuthorizationManagerFactory.class, (Class[])new Class[]{RequestAuthorizationContext.class});
        if (context.getBeanNamesForType(authorizationManagerFactoryType).length == 0) {
            authorizationManagerFactoryType = ResolvableType.forClassWithGenerics(AuthorizationManagerFactory.class, (Class[])new Class[]{Object.class});
        }
        ObjectProvider authorizationManagerFactoryProvider = context.getBeanProvider(authorizationManagerFactoryType);
        return (AuthorizationManagerFactory)authorizationManagerFactoryProvider.getIfAvailable(() -> {
            RoleHierarchy roleHierarchy = (RoleHierarchy)context.getBeanProvider(RoleHierarchy.class).getIfAvailable(NullRoleHierarchy::new);
            GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)context.getBeanProvider(GrantedAuthorityDefaults.class).getIfAvailable();
            String rolePrefix = grantedAuthorityDefaults != null ? grantedAuthorityDefaults.getRolePrefix() : "ROLE_";
            DefaultAuthorizationManagerFactory authorizationManagerFactory = new DefaultAuthorizationManagerFactory();
            authorizationManagerFactory.setRoleHierarchy(roleHierarchy);
            authorizationManagerFactory.setRolePrefix(rolePrefix);
            return authorizationManagerFactory;
        });
    }

    public AuthorizationManagerRequestMatcherRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void configure(H http) {
        AuthorizationManager<HttpServletRequest> authorizationManager = this.registry.createAuthorizationManager();
        AuthorizationFilter authorizationFilter = new AuthorizationFilter(authorizationManager);
        authorizationFilter.setAuthorizationEventPublisher(this.publisher);
        authorizationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        http.addFilter((Filter)this.postProcess(authorizationFilter));
    }

    private AuthorizationManagerRequestMatcherRegistry addMapping(List<? extends RequestMatcher> matchers, AuthorizationManager<? super RequestAuthorizationContext> manager) {
        for (RequestMatcher requestMatcher : matchers) {
            this.registry.addMapping(requestMatcher, manager);
        }
        return this.registry;
    }

    AuthorizationManagerRequestMatcherRegistry addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
        this.registry.addFirst(matcher, manager);
        return this.registry;
    }

    public final class AuthorizationManagerRequestMatcherRegistry
    extends AbstractRequestMatcherRegistry<AuthorizedUrl> {
        private final RequestMatcherDelegatingAuthorizationManager.Builder managerBuilder = RequestMatcherDelegatingAuthorizationManager.builder();
        private List<RequestMatcher> unmappedMatchers;
        private int mappingCount;

        private AuthorizationManagerRequestMatcherRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        private void addMapping(RequestMatcher matcher, AuthorizationManager<? super RequestAuthorizationContext> manager) {
            this.unmappedMatchers = null;
            this.managerBuilder.add(matcher, manager);
            ++this.mappingCount;
        }

        private void addFirst(RequestMatcher matcher, AuthorizationManager<? super RequestAuthorizationContext> manager) {
            this.unmappedMatchers = null;
            this.managerBuilder.mappings(m -> m.add(0, new RequestMatcherEntry(matcher, (Object)manager)));
            ++this.mappingCount;
        }

        private AuthorizationManager<HttpServletRequest> createAuthorizationManager() {
            Assert.state((this.unmappedMatchers == null ? 1 : 0) != 0, () -> "An incomplete mapping was found for " + String.valueOf(this.unmappedMatchers) + ". Try completing it with something like requestUrls().<something>.hasRole('USER')");
            Assert.state((this.mappingCount > 0 ? 1 : 0) != 0, (String)"At least one mapping is required (for example, authorizeHttpRequests().anyRequest().authenticated())");
            AuthorizationManager manager = (AuthorizationManager)AuthorizeHttpRequestsConfigurer.this.postProcess(this.managerBuilder.build());
            return AuthorizeHttpRequestsConfigurer.this.postProcessor.postProcess(manager);
        }

        @Override
        protected AuthorizedUrl chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.unmappedMatchers = requestMatchers;
            return new AuthorizedUrl(requestMatchers, AuthorizeHttpRequestsConfigurer.this.authorizationManagerFactory);
        }

        public AuthorizationManagerRequestMatcherRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            AuthorizeHttpRequestsConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }
    }

    public class AuthorizedUrl {
        private final List<? extends RequestMatcher> matchers;
        private AuthorizationManagerFactory<? super RequestAuthorizationContext> authorizationManagerFactory;
        private boolean not;

        AuthorizedUrl(List<? extends RequestMatcher> matchers, AuthorizationManagerFactory<? super RequestAuthorizationContext> authorizationManagerFactory) {
            this.matchers = matchers;
            this.authorizationManagerFactory = authorizationManagerFactory;
        }

        protected List<? extends RequestMatcher> getMatchers() {
            return this.matchers;
        }

        void setAuthorizationManagerFactory(AuthorizationManagerFactory<? super RequestAuthorizationContext> authorizationManagerFactory) {
            this.authorizationManagerFactory = authorizationManagerFactory;
        }

        public AuthorizedUrl not() {
            this.not = true;
            return this;
        }

        public AuthorizationManagerRequestMatcherRegistry permitAll() {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.permitAll());
        }

        public AuthorizationManagerRequestMatcherRegistry denyAll() {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.denyAll());
        }

        public AuthorizationManagerRequestMatcherRegistry hasRole(String role) {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.hasRole(role));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyRole(String ... roles) {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.hasAnyRole(roles));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAllRoles(String ... roles) {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.hasAllRoles(roles));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAuthority(String authority) {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.hasAuthority(authority));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyAuthority(String ... authorities) {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.hasAnyAuthority(authorities));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAllAuthorities(String ... authorities) {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.hasAllAuthorities(authorities));
        }

        public AuthorizationManagerRequestMatcherRegistry authenticated() {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.authenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry fullyAuthenticated() {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.fullyAuthenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry rememberMe() {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.rememberMe());
        }

        public AuthorizationManagerRequestMatcherRegistry anonymous() {
            return this.access((AuthorizationManager<? super RequestAuthorizationContext>)this.authorizationManagerFactory.anonymous());
        }

        public org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer$AuthorizedUrl.AuthorizedUrlVariable hasVariable(String variable) {
            return new AuthorizedUrlVariable(variable);
        }

        public AuthorizationManagerRequestMatcherRegistry access(AuthorizationManager<? super RequestAuthorizationContext> manager) {
            Assert.notNull(manager, (String)"manager cannot be null");
            return this.not ? AuthorizeHttpRequestsConfigurer.this.addMapping(this.matchers, (AuthorizationManager<RequestAuthorizationContext>)AuthorizationManagers.not(manager)) : AuthorizeHttpRequestsConfigurer.this.addMapping(this.matchers, manager);
        }

        public final class AuthorizedUrlVariable {
            private final String variable;

            private AuthorizedUrlVariable(String variable) {
                this.variable = variable;
            }

            public AuthorizationManagerRequestMatcherRegistry equalTo(Function<Authentication, String> function) {
                return AuthorizedUrl.this.access((AuthorizationManager<? super RequestAuthorizationContext>)((AuthorizationManager)(auth, requestContext) -> {
                    String value = (String)requestContext.getVariables().get(this.variable);
                    return new AuthorizationDecision(((String)function.apply((Authentication)auth.get())).equals(value));
                }));
            }
        }
    }
}

