/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerCsrfTokenRequestAttributeHandler
implements ServerCsrfTokenRequestHandler {
    private static final Log logger = LogFactory.getLog(ServerCsrfTokenRequestAttributeHandler.class);
    private boolean isTokenFromMultipartDataEnabled;

    @Override
    public void handle(ServerWebExchange exchange, Mono<CsrfToken> csrfToken) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        Assert.notNull(csrfToken, (String)"csrfToken cannot be null");
        exchange.getAttributes().put(CsrfToken.class.getName(), csrfToken);
        logger.trace((Object)LogMessage.format((String)"Wrote a CSRF token to the [%s] exchange attribute", (Object)CsrfToken.class.getName()));
    }

    @Override
    public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange, CsrfToken csrfToken) {
        return ServerCsrfTokenRequestHandler.super.resolveCsrfTokenValue(exchange, csrfToken).switchIfEmpty(this.tokenFromMultipartData(exchange, csrfToken));
    }

    public void setTokenFromMultipartDataEnabled(boolean tokenFromMultipartDataEnabled) {
        this.isTokenFromMultipartDataEnabled = tokenFromMultipartDataEnabled;
    }

    private Mono<String> tokenFromMultipartData(ServerWebExchange exchange, CsrfToken expected) {
        if (!this.isTokenFromMultipartDataEnabled) {
            return Mono.empty();
        }
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        MediaType contentType = headers.getContentType();
        if (!MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
            return Mono.empty();
        }
        return exchange.getMultipartData().mapNotNull(d -> (Part)d.getFirst((Object)expected.getParameterName())).cast(FormFieldPart.class).map(FormFieldPart::value);
    }
}

