/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.text;

import org.apache.nifi.util.text.DateTimeMatcher;

public class StartsWithDigitsDateTimeMatcher
implements DateTimeMatcher {
    private final int expectedNumberOfDigits;

    public StartsWithDigitsDateTimeMatcher(int expectedNumberOfDigits) {
        this.expectedNumberOfDigits = expectedNumberOfDigits;
    }

    @Override
    public boolean matches(String text) {
        if (text.length() < this.expectedNumberOfDigits) {
            return false;
        }
        for (int i = 0; i < this.expectedNumberOfDigits; ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

