/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.commitgraph;

import org.eclipse.jgit.internal.storage.commitgraph.ChangedPathFilter;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.commitgraph.GraphChangedPathFilterData;
import org.eclipse.jgit.internal.storage.commitgraph.GraphCommitData;
import org.eclipse.jgit.internal.storage.commitgraph.GraphObjectIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

class CommitGraphV1
implements CommitGraph {
    private final GraphObjectIndex idx;
    private final GraphCommitData commitData;
    private final GraphChangedPathFilterData cpfData;

    CommitGraphV1(GraphObjectIndex index, GraphCommitData commitData, GraphChangedPathFilterData cpfData) {
        this.idx = index;
        this.commitData = commitData;
        this.cpfData = cpfData;
    }

    @Override
    public int findGraphPosition(AnyObjectId commit) {
        return this.idx.findGraphPosition(commit);
    }

    @Override
    public CommitGraph.CommitData getCommitData(int graphPos) {
        if (graphPos < 0 || (long)graphPos >= this.getCommitCnt()) {
            return null;
        }
        return this.commitData.getCommitData(graphPos);
    }

    @Override
    public ObjectId getObjectId(int graphPos) {
        return this.idx.getObjectId(graphPos);
    }

    @Override
    public ChangedPathFilter getChangedPathFilter(int graphPos) {
        return this.cpfData.getChangedPathFilter(graphPos);
    }

    @Override
    public long getCommitCnt() {
        return this.idx.getCommitCnt();
    }
}

