/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.TenantEntity;

public class AccessPolicyResult
extends AbstractWritableResult<AccessPolicyEntity> {
    private final AccessPolicyEntity accessPolicyEntity;

    public AccessPolicyResult(ResultType resultType, AccessPolicyEntity accessPolicyEntity) {
        super(resultType);
        this.accessPolicyEntity = Objects.requireNonNull(accessPolicyEntity);
    }

    @Override
    public AccessPolicyEntity getResult() {
        return this.accessPolicyEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        AccessPolicyDTO accessPolicyDTO = this.accessPolicyEntity.getComponent();
        output.printf("Resource: %s\nAction  : %s\nUsers   : %s\nGroups  : %s\n", accessPolicyDTO.getResource(), accessPolicyDTO.getAction(), this.joinTenantIdentity(accessPolicyDTO.getUsers()), this.joinTenantIdentity(accessPolicyDTO.getUserGroups()));
    }

    private String joinTenantIdentity(Set<TenantEntity> entities) {
        return entities.stream().map(e -> e.getComponent() != null ? e.getComponent().getIdentity() : e.getId()).collect(Collectors.joining(", "));
    }
}

