/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.PoliciesClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;

public class JerseyPoliciesClient
extends AbstractJerseyClient
implements PoliciesClient {
    private final WebTarget policiesTarget;

    public JerseyPoliciesClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyPoliciesClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.policiesTarget = baseTarget.path("/policies");
    }

    @Override
    public AccessPolicyEntity getAccessPolicy(String resource, String action) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)resource) || StringUtils.isBlank((CharSequence)action)) {
            throw new IllegalArgumentException("Resouce and action cannot be null");
        }
        return this.executeAction("Error retrieving configuration of access policy", () -> {
            WebTarget target = this.policiesTarget.path(action).path(resource);
            return (AccessPolicyEntity)this.getRequestBuilder(target).get(AccessPolicyEntity.class);
        });
    }

    @Override
    public AccessPolicyEntity createAccessPolicy(AccessPolicyEntity accessPolicyEntity) throws NiFiClientException, IOException {
        if (accessPolicyEntity == null) {
            throw new IllegalArgumentException("Access policy entity cannot be null");
        }
        return this.executeAction("Error creating access policy", () -> (AccessPolicyEntity)this.getRequestBuilder(this.policiesTarget).post(Entity.entity((Object)accessPolicyEntity, (String)"application/json"), AccessPolicyEntity.class));
    }

    @Override
    public AccessPolicyEntity updateAccessPolicy(AccessPolicyEntity accessPolicyEntity) throws NiFiClientException, IOException {
        if (accessPolicyEntity == null) {
            throw new IllegalArgumentException("Access policy entity cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)accessPolicyEntity.getId())) {
            throw new IllegalArgumentException("Access policy entity must contain an id");
        }
        return this.executeAction("Error updating access policy", () -> {
            WebTarget target = this.policiesTarget.path(accessPolicyEntity.getId());
            return (AccessPolicyEntity)this.getRequestBuilder(target).put(Entity.entity((Object)accessPolicyEntity, (String)"application/json"), AccessPolicyEntity.class);
        });
    }
}

