/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

public class RuntimeValidatorResult {
    private final String subject;
    private final String explanation;
    private final Outcome outcome;

    protected RuntimeValidatorResult(Builder builder) {
        this.subject = builder.subject;
        this.explanation = builder.explanation;
        this.outcome = builder.outcome;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public static final class Builder {
        private String subject = "";
        private String explanation = "";
        private Outcome outcome = Outcome.FAILED;

        public Builder subject(String subject) {
            if (subject != null) {
                this.subject = subject;
            }
            return this;
        }

        public Builder explanation(String explanation) {
            if (explanation != null) {
                this.explanation = explanation;
            }
            return this;
        }

        public Builder outcome(Outcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public RuntimeValidatorResult build() {
            return new RuntimeValidatorResult(this);
        }
    }

    public static enum Outcome {
        SUCCESSFUL,
        FAILED,
        SKIPPED;

    }
}

