/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.command.process.StandardManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.StandardProcessBuilderProvider;
import org.apache.nifi.bootstrap.configuration.ApplicationClassName;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.apache.nifi.bootstrap.process.RuntimeValidatorExecutor;
import org.apache.nifi.bootstrap.property.SecurityApplicationPropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunBootstrapCommand
implements BootstrapCommand {
    private static final String SPACE_SEPARATOR = " ";
    private static final Logger commandLogger = LoggerFactory.getLogger((String)ApplicationClassName.BOOTSTRAP_COMMAND.getName());
    private static final Logger logger = LoggerFactory.getLogger(RunBootstrapCommand.class);
    private static final RuntimeValidatorExecutor runtimeValidatorExecutor = new RuntimeValidatorExecutor();
    private final ConfigurationProvider configurationProvider;
    private final ProcessHandleProvider processHandleProvider;
    private final ManagementServerAddressProvider managementServerAddressProvider;
    private CommandStatus commandStatus = CommandStatus.ERROR;

    public RunBootstrapCommand(ConfigurationProvider configurationProvider, ProcessHandleProvider processHandleProvider) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
        this.processHandleProvider = Objects.requireNonNull(processHandleProvider);
        this.managementServerAddressProvider = new StandardManagementServerAddressProvider(configurationProvider);
    }

    @Override
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    @Override
    public void run() {
        try {
            Optional<ProcessHandle> applicationProcessHandle = this.processHandleProvider.findApplicationProcessHandle();
            if (applicationProcessHandle.isEmpty()) {
                this.writePlatformProperties();
                runtimeValidatorExecutor.execute();
                SecurityApplicationPropertyHandler securityApplicationPropertyHandler = new SecurityApplicationPropertyHandler(logger);
                securityApplicationPropertyHandler.handleProperties(this.configurationProvider.getApplicationProperties());
                StandardProcessBuilderProvider processBuilderProvider = new StandardProcessBuilderProvider(this.configurationProvider, this.managementServerAddressProvider);
                ProcessBuilder processBuilder = processBuilderProvider.getApplicationProcessBuilder();
                processBuilder.inheritIO();
                String command = String.join((CharSequence)SPACE_SEPARATOR, processBuilder.command());
                logger.info(command);
                Process process = processBuilder.start();
                if (process.isAlive()) {
                    this.commandStatus = CommandStatus.SUCCESS;
                    commandLogger.info("Application Process [{}] started", (Object)process.pid());
                } else {
                    this.commandStatus = CommandStatus.STOPPED;
                    commandLogger.error("Application Process [{}] start failed", (Object)process.pid());
                }
            } else {
                commandLogger.info("Application Process [{}] running", (Object)applicationProcessHandle.get().pid());
                this.commandStatus = CommandStatus.ERROR;
            }
        }
        catch (Throwable e) {
            commandLogger.warn("Application Process run failed", e);
            this.commandStatus = CommandStatus.FAILED;
        }
    }

    private void writePlatformProperties() {
        Runtime.Version version = Runtime.version();
        logger.info("Java Version: {}", (Object)version);
        Runtime runtime = Runtime.getRuntime();
        logger.info("Available Processors: {}", (Object)runtime.availableProcessors());
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystem instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOperatingSystem = (UnixOperatingSystemMXBean)operatingSystem;
            logger.info("Total Memory: {}", (Object)unixOperatingSystem.getTotalMemorySize());
            logger.info("Maximum File Descriptors: {}", (Object)unixOperatingSystem.getMaxFileDescriptorCount());
        }
    }
}

