/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package javax.annotation;

import javax.annotation.meta.When;

/** Compatibility layer for {@link org.netbeans.api.annotations.common}.
 * This is a transitively referenced JSR-305 element from other common NetBeans
 * annotations. Don't reference this item directly. Rather use one of the
 * pre-configured {@link org.netbeans.api.annotations.common} annotations.
 * 
 * @since 1.40
 */
public @interface Nonnull {
    /** When attribute.
     * @return defaults to {@link When#MAYBE}
     * @since 1.40
     */
    When when() default When.MAYBE;
}
