/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.project.ExtraProjectJavadocForBinaryQueryImpl;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public final class ExtraProjectSourceForBinaryQueryImpl
extends ProjectOpenedHook
implements SourceForBinaryQueryImplementation2 {
    private static final String REF_START = "file.reference.";
    private static final String SOURCE_START = "source.reference.";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final Map<URL, ExtraResult> cache = new HashMap<URL, ExtraResult>();
    private PropertyChangeListener listener;
    private Map<URL, URL> mappings = new HashMap<URL, URL>();
    private final Object MAPPINGS_LOCK = new Object();
    private Project project;

    public ExtraProjectSourceForBinaryQueryImpl(Project prj, AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.project = prj;
        this.listener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().startsWith(ExtraProjectSourceForBinaryQueryImpl.SOURCE_START)) {
                    ExtraProjectSourceForBinaryQueryImpl.this.checkAndRegisterExtraSources(ExtraProjectSourceForBinaryQueryImpl.this.getExtraSources());
                    ArrayList<ExtraResult> results = null;
                    Map<URL, ExtraResult> map = ExtraProjectSourceForBinaryQueryImpl.this.cache;
                    synchronized (map) {
                        results = new ArrayList<ExtraResult>(ExtraProjectSourceForBinaryQueryImpl.this.cache.values());
                    }
                    for (ExtraResult res : results) {
                        res.fire();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        Map<URL, ExtraResult> map = this.cache;
        synchronized (map) {
            ExtraResult res = this.cache.get(binaryRoot);
            if (res != null) {
                return res;
            }
            if (this.mappings.containsKey(binaryRoot)) {
                res = new ExtraResult(binaryRoot);
                this.cache.put(binaryRoot, res);
                return res;
            }
        }
        return null;
    }

    @Override
    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    @Override
    protected void projectOpened() {
        this.checkAndRegisterExtraSources(this.getExtraSources());
        this.evaluator.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void projectClosed() {
        this.checkAndRegisterExtraSources(new HashMap<URL, URL>());
        this.evaluator.removePropertyChangeListener(this.listener);
    }

    private Map<URL, URL> getExtraSources() {
        return ProjectManager.mutex().readAccess(new Mutex.Action<Map<URL, URL>>(){

            @Override
            public Map<URL, URL> run() {
                HashMap<URL, URL> result = new HashMap<URL, URL>();
                Map<String, String> props = ExtraProjectSourceForBinaryQueryImpl.this.evaluator.getProperties();
                if (props != null) {
                    for (Map.Entry<String, String> entry : props.entrySet()) {
                        File src;
                        if (!entry.getKey().startsWith(ExtraProjectSourceForBinaryQueryImpl.REF_START)) continue;
                        String val = entry.getKey().substring(ExtraProjectSourceForBinaryQueryImpl.REF_START.length());
                        String sourceKey = ExtraProjectSourceForBinaryQueryImpl.SOURCE_START + val;
                        String[] source = ExtraProjectJavadocForBinaryQueryImpl.stripJARPath(props.get(sourceKey));
                        File bin = PropertyUtils.resolveFile(FileUtil.toFile(ExtraProjectSourceForBinaryQueryImpl.this.helper.getProjectDirectory()), entry.getValue());
                        URL binURL = FileUtil.urlForArchiveOrDir(bin);
                        if (source[0] == null || binURL == null || !(src = PropertyUtils.resolveFile(FileUtil.toFile(ExtraProjectSourceForBinaryQueryImpl.this.helper.getProjectDirectory()), source[0])).exists()) continue;
                        try {
                            URL url = BaseUtilities.toURI(src).toURL();
                            if (FileUtil.isArchiveFile(url)) {
                                url = FileUtil.getArchiveRoot(url);
                            }
                            if (source[1] != null) {
                                assert (url.toExternalForm().endsWith("!/")) : url.toExternalForm();
                                url = new URL(url.toExternalForm() + source[1]);
                            }
                            result.put(binURL, url);
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace(ex);
                        }
                    }
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRegisterExtraSources(Map<URL, URL> newvalues) {
        URL jaradd;
        HashSet<URL> added;
        HashSet<URL> removed;
        Iterator iterator = this.MAPPINGS_LOCK;
        synchronized (iterator) {
            removed = new HashSet<URL>(this.mappings.keySet());
            removed.removeAll(newvalues.keySet());
            added = new HashSet<URL>(newvalues.keySet());
            added.removeAll(this.mappings.keySet());
            this.mappings = newvalues;
        }
        for (URL rem : removed) {
            Map<URL, ExtraResult> map = this.cache;
            synchronized (map) {
                ExtraResult res = this.cache.remove(rem);
                if (res != null) {
                    res.fire();
                }
            }
            try {
                jaradd = FileUtil.getArchiveFile(rem);
                if (jaradd != null) {
                    rem = jaradd;
                }
                FileOwnerQuery.markExternalOwner(rem.toURI(), null, 0);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        for (URL add : added) {
            try {
                jaradd = FileUtil.getArchiveFile(add);
                if (jaradd != null) {
                    add = jaradd;
                }
                FileOwnerQuery.markExternalOwner(add.toURI(), this.project, 0);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    private class ExtraResult
    implements SourceForBinaryQueryImplementation2.Result {
        private URL binaryroot;
        private ChangeSupport chs = new ChangeSupport(this);

        public ExtraResult(URL binary) {
            this.binaryroot = binary;
        }

        @Override
        public FileObject[] getRoots() {
            FileObject fo;
            URL source = ExtraProjectSourceForBinaryQueryImpl.this.mappings.get(this.binaryroot);
            if (source != null && (fo = URLMapper.findFileObject(source)) != null) {
                return new FileObject[]{fo};
            }
            return new FileObject[0];
        }

        public void fire() {
            this.chs.fireChange();
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.chs.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.chs.removeChangeListener(l);
        }

        @Override
        public boolean preferSources() {
            return false;
        }
    }
}

