/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public final class SessionManager {
    public static final String PROP_OPEN = "session_open";
    public static final String PROP_CLOSE = "session_close";
    public static final String LAYER_SESSION = "session";
    public static final String LAYER_INSTALL = "install";
    private static SessionManager sm = null;
    private SystemFileSystem systemFS;
    private HashMap<String, FileSystem> layers = new HashMap();
    private transient List<PropertyChangeListener> propertyChangeListeners;

    private SessionManager() {
    }

    public static SessionManager getDefault() {
        if (sm == null) {
            sm = new SessionManager();
        }
        return sm;
    }

    public FileSystem create(File userDir, File homeDir, File[] extradirs) throws PropertyVetoException, IOException {
        this.systemFS = SystemFileSystem.create(userDir, homeDir, extradirs);
        this.layers.put(LAYER_INSTALL, this.systemFS.getInstallationLayer());
        this.layers.put(LAYER_SESSION, this.systemFS.getUserLayer());
        return this.systemFS;
    }

    public void close() {
        this.firePropertyChange(PROP_CLOSE);
        this.waitForLocks();
    }

    public FileSystem getLayer(String name) {
        return this.layers.get(name);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners != null) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String name) {
        ArrayList<PropertyChangeListener> list;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this.propertyChangeListeners == null || this.propertyChangeListeners.size() == 0) {
                return;
            }
            list = new ArrayList<PropertyChangeListener>(this.propertyChangeListeners);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, null, null);
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((PropertyChangeListener)list.get(i)).propertyChange(event);
                continue;
            }
            catch (RuntimeException e) {
                Exceptions.printStackTrace(e);
            }
        }
    }

    private void waitForLocks() {
        int count;
        try {
            for (count = 50; LocalFileSystemEx.hasLocks() && 0 < count; --count) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LocalFileSystemEx.hasLocks()) {
            String[] locks = LocalFileSystemEx.getLocks();
            StringBuilder msg = new StringBuilder(256);
            msg.append("Settings saving ");
            msg.append(count == 0 ? "timeout!" : "interrupted!");
            msg.append("\nList of pending locks:\n");
            for (int i = 0; i < locks.length; ++i) {
                msg.append(locks[i]);
                msg.append("\n");
            }
            System.err.println(msg.toString());
        }
    }
}

