/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import jpt.sun.tools.javac.api.DiagnosticFormatter;
import jpt.sun.tools.javac.api.Formattable;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.file.PathFileObject;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.util.AbstractDiagnosticFormatter;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.DiagnosticSource;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Options;
import jpt.sun.tools.javac.util.StringUtils;
import jpt30.tools.JavaFileObject;

public final class RawDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    RawDiagnosticPosHelper rawDiagnosticPosHelper;
    private static final Set<String> CODES_NEEDING_SOURCE_NORMALIZATION = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compiler.note.preview.filename", "compiler.note.preview.plural")));

    public RawDiagnosticFormatter(Options options) {
        super(null, new AbstractDiagnosticFormatter.SimpleConfiguration(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatDiagnostic(JCDiagnostic d, Locale l) {
        try {
            this.rawDiagnosticPosHelper = new RawDiagnosticPosHelper(d);
            StringBuilder buf = new StringBuilder();
            if (d.getPosition() != -1L) {
                buf.append(this.formatSource(d, false, (Locale)null));
                buf.append(':');
                buf.append(this.formatPosition(d, DiagnosticFormatter.PositionKind.LINE, (Locale)null));
                buf.append(':');
                buf.append(this.formatPosition(d, DiagnosticFormatter.PositionKind.COLUMN, (Locale)null));
                buf.append(':');
            } else if (d.getSource() != null && d.getSource().getKind() == JavaFileObject.Kind.CLASS) {
                buf.append(this.formatSource(d, false, (Locale)null));
                buf.append(":-:-:");
            } else {
                buf.append('-');
            }
            buf.append(' ');
            buf.append(this.formatMessage(d, (Locale)null));
            if (this.displaySource(d)) {
                buf.append("\n");
                buf.append(this.formatSourceLine(d, 0));
            }
            String string = buf.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.rawDiagnosticPosHelper = null;
        }
    }

    @Override
    public String formatMessage(JCDiagnostic d, Locale l) {
        List<String> subDiags;
        StringBuilder buf = new StringBuilder();
        Collection<String> args = this.formatArguments(d, l);
        buf.append(this.localize(null, d.getCode(), args.toArray()));
        if (d.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS) && (subDiags = this.formatSubdiagnostics(d, null)).nonEmpty()) {
            String sep = "";
            buf.append(",{");
            for (String sub : this.formatSubdiagnostics(d, null)) {
                buf.append(sep);
                buf.append("(");
                buf.append(sub);
                buf.append(")");
                sep = ",";
            }
            buf.append('}');
        }
        return buf.toString();
    }

    @Override
    protected String formatArgument(JCDiagnostic diag, Object arg, Locale l) {
        String s;
        if (arg instanceof Formattable) {
            s = arg.toString();
        } else if (arg instanceof JCTree.JCExpression) {
            JCTree.JCExpression expression = (JCTree.JCExpression)arg;
            Assert.checkNonNull(this.rawDiagnosticPosHelper);
            s = "@" + this.rawDiagnosticPosHelper.getPosition(expression);
        } else if (arg instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)arg;
            s = pathFileObject.getShortName();
        } else if (arg instanceof JCTree.Tag) {
            JCTree.Tag tag = (JCTree.Tag)((Object)arg);
            s = "compiler.misc.tree.tag." + StringUtils.toLowerCase(tag.name());
        } else {
            s = arg instanceof Source && arg == Source.DEFAULT && CODES_NEEDING_SOURCE_NORMALIZATION.contains(diag.getCode()) ? "DEFAULT" : super.formatArgument(diag, arg, null);
        }
        return arg instanceof JCDiagnostic ? "(" + s + ")" : s;
    }

    @Override
    protected String localize(Locale l, String key, Object ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        String sep = ": ";
        for (Object o : args) {
            buf.append(sep);
            buf.append(o);
            sep = ", ";
        }
        return buf.toString();
    }

    @Override
    public boolean isRaw() {
        return true;
    }

    static class RawDiagnosticPosHelper {
        private final JCDiagnostic diag;

        RawDiagnosticPosHelper(JCDiagnostic diag) {
            this.diag = diag;
        }

        String getPosition(JCTree.JCExpression exp) {
            DiagnosticSource diagSource = this.diag.getDiagnosticSource();
            long diagLine = this.diag.getLineNumber();
            long expLine = diagSource.getLineNumber(exp.pos);
            long expCol = diagSource.getColumnNumber(exp.pos, false);
            return expLine == diagLine ? String.valueOf(expCol) : expLine + ":" + expCol;
        }
    }
}

