/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class AutomaticModuleNameCompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private static final Logger LOG = Logger.getLogger(AutomaticModuleNameCompilerOptionsQueryImpl.class.getName());
    private static final String OPT_AUTOMATIC_MODULE_NAME = "-XDautomatic-module-name";
    private static final String ATTR_AUTOMATIC_MOD_NAME = "Automatic-Module-Name";
    private static final String MODULE_INFO_JAVA = "module-info.java";
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final SourceRoots sources;
    private final String manifestProp;
    private final AtomicReference<R> result;

    AutomaticModuleNameCompilerOptionsQueryImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull SourceRoots sources, @NonNull String manifestProp) {
        Parameters.notNull("helper", helper);
        Parameters.notNull("eval", eval);
        Parameters.notNull("sources", sources);
        Parameters.notNull("manifestProp", manifestProp);
        this.helper = helper;
        this.eval = eval;
        this.sources = sources;
        this.manifestProp = manifestProp;
        this.result = new AtomicReference();
    }

    @Override
    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        if (AutomaticModuleNameCompilerOptionsQueryImpl.isOwned(file, this.sources)) {
            R r = this.result.get();
            if (r == null && !this.result.compareAndSet(null, r = new R(this.helper, this.eval, this.sources, this.manifestProp))) {
                r = this.result.get();
            }
            assert (r != null);
            return r;
        }
        return null;
    }

    private static boolean isOwned(@NonNull FileObject file, @NonNull SourceRoots roots) {
        for (FileObject root : roots.getRoots()) {
            if (!root.equals(file) && !FileUtil.isParentOf(root, file)) continue;
            return true;
        }
        return false;
    }

    private static final class R
    extends CompilerOptionsQueryImplementation.Result
    implements PropertyChangeListener {
        private final AntProjectHelper helper;
        private final PropertyEvaluator eval;
        private final SourceRoots sources;
        private final String manifestProp;
        private final ChangeSupport listeners;
        private final FileChangeListener manifestListener;
        private final FileChangeListener modInfoListener;
        private List<? extends String> cache;
        private File currentManifestFile;
        private Collection<? extends File> currentModuleInfos = Collections.emptySet();

        R(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull SourceRoots sources, @NonNull String manifestProp) {
            this.helper = helper;
            this.eval = eval;
            this.sources = sources;
            this.manifestProp = manifestProp;
            this.listeners = new ChangeSupport(this);
            EnumSet<FCL.Op> filter = EnumSet.allOf(FCL.Op.class);
            filter.remove((Object)FCL.Op.FILE_ATTR_CHANGED);
            this.manifestListener = new FCL(this::reset, filter);
            filter = EnumSet.allOf(FCL.Op.class);
            filter.remove((Object)FCL.Op.FILE_ATTR_CHANGED);
            filter.remove((Object)FCL.Op.FILE_CHANGED);
            this.modInfoListener = new FCL(this::reset, filter);
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange(this, this.eval));
            this.sources.addPropertyChangeListener(WeakListeners.propertyChange(this, this.sources));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends String> getArguments() {
            Collection<? extends File> lastModuleInfos;
            File lastManifestFile;
            List<String> res;
            R r = this;
            synchronized (r) {
                res = this.cache;
                lastManifestFile = this.currentManifestFile;
                lastModuleInfos = this.currentModuleInfos;
            }
            File manifestFile = null;
            ArrayList<? extends File> moduleInfos = new ArrayList<File>();
            if (res == null) {
                res = Collections.emptyList();
                if (!this.hasModuleInfo(moduleInfos)) {
                    manifestFile = Optional.ofNullable(this.eval.getProperty(this.manifestProp)).map(this.helper::resolveFile).orElse(null);
                    if (manifestFile != null && manifestFile.isFile() && manifestFile.canRead()) {
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(manifestFile));){
                            Manifest manifest = new Manifest(in);
                            String moduleName = manifest.getMainAttributes().getValue(AutomaticModuleNameCompilerOptionsQueryImpl.ATTR_AUTOMATIC_MOD_NAME);
                            if (moduleName != null) {
                                res = Collections.singletonList(String.format("%s:%s", AutomaticModuleNameCompilerOptionsQueryImpl.OPT_AUTOMATIC_MODULE_NAME, moduleName));
                            }
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.WARNING, "Cannot read: {0}, reason: {1}", new Object[]{manifestFile.getAbsolutePath(), ioe.getMessage()});
                        }
                    }
                }
                R r2 = this;
                synchronized (r2) {
                    if (this.cache == null) {
                        this.cache = res;
                        boolean sameManifests = Objects.equals(lastManifestFile, manifestFile);
                        if (lastManifestFile != null && !sameManifests) {
                            FileUtil.removeFileChangeListener(this.manifestListener, lastManifestFile);
                        }
                        if (manifestFile != null && !sameManifests) {
                            FileUtil.addFileChangeListener(this.manifestListener, manifestFile);
                        }
                        this.currentManifestFile = manifestFile;
                        for (File file : lastModuleInfos) {
                            FileUtil.removeFileChangeListener(this.modInfoListener, file);
                        }
                        for (File file : moduleInfos) {
                            FileUtil.addFileChangeListener(this.modInfoListener, file);
                        }
                        this.currentModuleInfos = moduleInfos;
                    } else {
                        res = this.cache;
                    }
                }
            }
            return res;
        }

        @Override
        public void addChangeListener(@NonNull ChangeListener listener) {
            this.listeners.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.listeners.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object from = evt.getSource();
            if (from == this.sources && SourceRoots.PROP_ROOTS.equals(propName)) {
                this.reset();
            } else if (from == this.eval && (propName == null || propName.equals(this.manifestProp))) {
                this.reset();
            }
        }

        private boolean hasModuleInfo(Collection<? super File> moduleInfos) {
            boolean vote = false;
            for (FileObject root : this.sources.getRoots()) {
                if (root.getFileObject(AutomaticModuleNameCompilerOptionsQueryImpl.MODULE_INFO_JAVA) != null) {
                    vote = true;
                }
                Optional.ofNullable(FileUtil.toFile(root)).map(f -> new File((File)f, AutomaticModuleNameCompilerOptionsQueryImpl.MODULE_INFO_JAVA)).ifPresent(moduleInfos::add);
            }
            return vote;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            R r = this;
            synchronized (r) {
                this.cache = null;
            }
            this.listeners.fireChange();
        }
    }

    private static final class FCL
    implements FileChangeListener {
        private final Runnable action;
        private final Set<? extends Op> filter;

        FCL(@NonNull Runnable action, @NonNull Set<? extends Op> filter) {
            this.action = action;
            this.filter = filter;
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            if (this.filter.contains((Object)Op.FOLDER_CREATED)) {
                this.action.run();
            }
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            if (this.filter.contains((Object)Op.FILE_CREATED)) {
                this.action.run();
            }
        }

        @Override
        public void fileChanged(FileEvent fe) {
            if (this.filter.contains((Object)Op.FILE_CHANGED)) {
                this.action.run();
            }
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            if (this.filter.contains((Object)Op.FILE_DELETED)) {
                this.action.run();
            }
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            if (this.filter.contains((Object)Op.FILE_RENAMED)) {
                this.action.run();
            }
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
            if (this.filter.contains((Object)Op.FILE_ATTR_CHANGED)) {
                this.action.run();
            }
        }

        private static enum Op {
            FILE_CREATED,
            FOLDER_CREATED,
            FILE_CHANGED,
            FILE_DELETED,
            FILE_RENAMED,
            FILE_ATTR_CHANGED;

        }
    }
}

