/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.eclipse.aether.internal.impl.filter.ruletree;

import java.util.stream.Stream;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

/**
 * UT for {@link PrefixTree}.
 */
public class PrefixTreeTest {
    @Test
    void smoke() {
        PrefixTree prefixTree = new PrefixTree("root");
        prefixTree.loadNodes(Stream.of("# comment", "", "/org/apache/maven"));
        assertTrue(prefixTree.acceptedPath("/org/apache/maven"));
        assertTrue(prefixTree.acceptedPath("/org/apache/maven/aaa"));

        assertFalse(prefixTree.acceptedPath("/org/apache/baz"));
        assertFalse(prefixTree.acceptedPath("/org/apache/baz/aaa"));
    }
}
