package org.apache.maven.plugin.coreit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * @goal it
 */
public class ItMojo
    extends AbstractMojo
{

    /**
     * @parameter default-value="${project.build.directory}/touch.txt"
     */
    private File touchFile;

    /**
     * NOTE: Using map to defer actual component init until mojo execution.
     * 
     * @component role="org.apache.maven.plugin.coreit.Component"
     */
    private Map components;

    public void execute()
        throws MojoExecutionException
    {
        for ( Iterator it = components.values().iterator(); it.hasNext(); )
        {
            Component comp = (Component) it.next();
            getLog().info( "Component properly contextualized: " + comp );
        }

        try
        {
            touchFile.getParentFile().mkdirs();

            touchFile.createNewFile();
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( e.getMessage(), e );
        }
    }

}
