/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class FileConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "file-configuration-resource";
    }

    public PlexusConfiguration[] handleRequest(Map parameters) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        File f = new File(this.getSource(parameters));
        if (!f.exists()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f + " cannot be found.");
        }
        XmlStreamReader configurationReader = null;
        try {
            configurationReader = ReaderFactory.newXmlReader((File)f);
            PlexusConfiguration[] plexusConfigurationArray = new PlexusConfiguration[]{PlexusTools.buildConfiguration(f.getAbsolutePath(), (Reader)configurationReader)};
            return plexusConfigurationArray;
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationProcessingException(e);
        }
        catch (IOException e) {
            throw new ConfigurationProcessingException(e);
        }
        finally {
            IOUtil.close((Reader)configurationReader);
        }
    }
}

