/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.avltree.ArrayMarshaller;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.partition.impl.btree.mavibot.KeyTupleValueCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.ValueTreeCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotTable<K, V>
extends AbstractTable<K, V> {
    private BTree<K, V> bt;
    private ArrayMarshaller<V> arrayMarshaller;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotTable.class);
    protected RecordManager recordMan;

    public MavibotTable(RecordManager recordMan, SchemaManager schemaManager, String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) throws IOException {
        this(recordMan, schemaManager, name, keySerializer, valueSerializer, allowDuplicates, 10000);
    }

    public MavibotTable(RecordManager recordMan, SchemaManager schemaManager, String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates, int cacheSize) throws IOException {
        super(schemaManager, name, keySerializer.getComparator(), valueSerializer.getComparator());
        this.recordMan = recordMan;
        this.bt = recordMan.getManagedTree(name);
        if (this.bt == null) {
            this.bt = BTreeFactory.createPersistedBTree((String)name, keySerializer, valueSerializer, (boolean)allowDuplicates, (int)cacheSize);
            try {
                recordMan.manage(this.bt);
            }
            catch (BTreeAlreadyManagedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.bt.setKeySerializer(keySerializer);
            this.bt.setValueSerializer(valueSerializer);
        }
        this.allowsDuplicates = allowDuplicates;
        this.arrayMarshaller = new ArrayMarshaller(this.valueComparator);
        this.count = this.bt.getNbElems();
    }

    public boolean has(PartitionTxn partitionTxn, K key) throws LdapException {
        try {
            return this.bt.hasKey(key);
        }
        catch (IOException ioe) {
            throw new LdapException((Throwable)ioe);
        }
        catch (KeyNotFoundException knfe) {
            throw new LdapException((Throwable)knfe);
        }
    }

    public boolean has(PartitionTxn transaction, K key, V value) throws LdapException {
        try {
            return this.bt.contains(key, value);
        }
        catch (IOException e) {
            throw new LdapException((Throwable)e);
        }
    }

    public boolean hasGreaterOrEqual(PartitionTxn transaction, K key) throws LdapException {
        try (TupleCursor cursor = null;){
            cursor = this.bt.browseFrom(key);
            boolean bl = cursor.hasNext();
            return bl;
        }
    }

    public boolean hasLessOrEqual(PartitionTxn transaction, K key) throws LdapException {
        try (TupleCursor cursor = null;){
            cursor = this.bt.browseFrom(key);
            org.apache.directory.mavibot.btree.Tuple tuple = null;
            if (cursor.hasNext()) {
                tuple = cursor.next();
            }
            if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
                boolean bl = true;
                return bl;
            }
            if (null == tuple) {
                boolean bl = this.count > 0L;
                return bl;
            }
            if (cursor.hasPrev()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean hasGreaterOrEqual(PartitionTxn transaction, K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_593, (Object[])new Object[0]));
        }
        try (ValueCursor valueCursor = null;){
            if (!this.bt.hasKey(key)) {
                boolean bl = false;
                return bl;
            }
            valueCursor = this.bt.getValues(key);
            int equal = this.bt.getValueSerializer().compare(val, valueCursor.next());
            boolean bl = equal >= 0;
            return bl;
        }
    }

    public boolean hasLessOrEqual(PartitionTxn partitionTxn, K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_593, (Object[])new Object[0]));
        }
        try {
            if (!this.bt.hasKey(key)) {
                return false;
            }
            ValueCursor dupHolder = this.bt.getValues(key);
            return dupHolder.hasNext();
        }
        catch (KeyNotFoundException knfe) {
            throw new LdapOtherException(knfe.getMessage(), (Throwable)knfe);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public V get(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return null;
        }
        try {
            return (V)this.bt.get(key);
        }
        catch (KeyNotFoundException knfe) {
            return null;
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public void put(PartitionTxn partitionTxn, K key, V value) throws LdapException {
        try {
            if (value == null || key == null) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_594, (Object[])new Object[0]));
            }
            Object existingVal = this.bt.insert(key, value);
            if (existingVal == null) {
                ++this.count;
            }
        }
        catch (IOException ioe) {
            LOG.error(I18n.err((I18n)I18n.ERR_131, (Object[])new Object[]{key, this.name}), (Throwable)ioe);
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void remove(PartitionTxn partitionTxn, K key) throws LdapException {
        try {
            if (key == null) {
                return;
            }
            if (this.bt.isAllowDuplicates()) {
                ValueCursor valueCursor = this.bt.getValues(key);
                int size = valueCursor.size();
                valueCursor.close();
                org.apache.directory.mavibot.btree.Tuple returned = this.bt.delete(key);
                if (null == returned) {
                    return;
                }
                this.count -= (long)size;
            } else {
                org.apache.directory.mavibot.btree.Tuple returned = this.bt.delete(key);
                if (null == returned) {
                    return;
                }
                --this.count;
            }
        }
        catch (IOException | KeyNotFoundException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_133, (Object[])new Object[]{key, this.name}), e);
            throw new LdapOtherException(e.getMessage(), e);
        }
    }

    public void remove(PartitionTxn partitionTxn, K key, V value) throws LdapException {
        try {
            if (key == null) {
                return;
            }
            org.apache.directory.mavibot.btree.Tuple tuple = this.bt.delete(key, value);
            if (tuple != null) {
                --this.count;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_132, (Object[])new Object[]{key, value, this.name}), (Throwable)e);
        }
    }

    public Cursor<Tuple<K, V>> cursor() {
        return new MavibotCursor(this);
    }

    public Cursor<Tuple<K, V>> cursor(PartitionTxn partitionTxn, K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor();
        }
        try {
            if (!this.allowsDuplicates) {
                Object val = this.bt.get(key);
                return new SingletonCursor((Object)new Tuple(key, val));
            }
            ValueCursor dupHolder = this.bt.getValues(key);
            return new KeyTupleValueCursor(dupHolder, key);
        }
        catch (KeyNotFoundException knfe) {
            return new EmptyCursor();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public Cursor<V> valueCursor(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor();
        }
        try {
            if (!this.allowsDuplicates) {
                Object val = this.bt.get(key);
                return new SingletonCursor(val);
            }
            ValueCursor dupCursor = this.bt.getValues(key);
            return new ValueTreeCursor(dupCursor);
        }
        catch (KeyNotFoundException knfe) {
            return new EmptyCursor();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public synchronized void close(PartitionTxn transaction) throws LdapException {
        try {
            this.sync();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public long count(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return 0L;
        }
        try {
            if (this.bt.isAllowDuplicates()) {
                ValueCursor dupHolder = this.bt.getValues(key);
                int size = dupHolder.size();
                dupHolder.close();
                return size;
            }
            if (this.bt.hasKey(key)) {
                return 1L;
            }
            return 0L;
        }
        catch (KeyNotFoundException knfe) {
            return 0L;
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    public ArrayTree<V> getDupsContainer(byte[] serialized) throws IOException {
        if (serialized == null) {
            return new ArrayTree(this.valueComparator);
        }
        return this.arrayMarshaller.deserialize(serialized);
    }

    protected BTree<K, V> getBTree() {
        return this.bt;
    }

    public synchronized void sync() throws IOException {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mavibot table :\n").append(super.toString());
        return sb.toString();
    }
}

