/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logger;

import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.juneau.assertions.StringAssertion;
import org.apache.juneau.assertions.ThrowableAssertion;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.logger.CallLoggerRule;
import org.apache.juneau.rest.logger.CallLoggingDetail;

public class BasicTestCaptureCallLogger
extends CallLogger {
    private AtomicReference<LogRecord> lastRecord = new AtomicReference();

    public BasicTestCaptureCallLogger() {
        super(BeanStore.INSTANCE);
    }

    public BasicTestCaptureCallLogger(BeanStore beanStore) {
        super(beanStore);
    }

    public StringAssertion assertMessage() {
        return new StringAssertion((Object)this.getMessage());
    }

    public StringAssertion assertMessageAndReset() {
        return new StringAssertion((Object)this.getMessageAndReset());
    }

    public ThrowableAssertion<Throwable> assertThrown() {
        return new ThrowableAssertion(this.getThrown());
    }

    public Level getLevel() {
        LogRecord r = this.lastRecord.get();
        return r == null ? null : r.getLevel();
    }

    public String getMessage() {
        LogRecord r = this.lastRecord.get();
        return r == null ? null : r.getMessage();
    }

    public String getMessageAndReset() {
        String msg = this.getMessage();
        this.reset();
        return msg;
    }

    public Throwable getThrown() {
        LogRecord r = this.lastRecord.get();
        return r == null ? null : r.getThrown();
    }

    public BasicTestCaptureCallLogger reset() {
        this.lastRecord.set(null);
        return this;
    }

    @Override
    protected CallLogger.Builder init(BeanStore beanStore) {
        return super.init(beanStore).normalRules((CallLoggerRule)CallLoggerRule.create(beanStore).statusFilter(x -> x >= 500).level(Level.SEVERE).requestDetail(CallLoggingDetail.HEADER).responseDetail(CallLoggingDetail.HEADER).build(), (CallLoggerRule)CallLoggerRule.create(beanStore).statusFilter(x -> x >= 400).level(Level.WARNING).requestDetail(CallLoggingDetail.STATUS_LINE).responseDetail(CallLoggingDetail.STATUS_LINE).build()).debugRules((CallLoggerRule)CallLoggerRule.create(beanStore).level(Level.SEVERE).requestDetail(CallLoggingDetail.ENTITY).responseDetail(CallLoggingDetail.ENTITY).build());
    }

    @Override
    protected void log(Level level, String msg, Throwable e) {
        LogRecord r = new LogRecord(level, msg);
        r.setThrown(e);
        this.lastRecord.set(r);
    }
}

