/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.juneau.Context;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public abstract class ContextSession {
    private final boolean debug;
    private final boolean unmodifiable;
    private final Context ctx;
    private final Map<String, Object> properties;
    private List<String> warnings;

    protected ContextSession(Builder builder) {
        AssertionUtils.assertArgNotNull((String)"builder", (Object)builder);
        this.ctx = builder.ctx;
        this.debug = Utils.opt((Object)builder.debug).orElse(this.ctx.isDebug());
        this.unmodifiable = builder.unmodifiable;
        LinkedHashMap sp = (LinkedHashMap)builder.properties.get();
        this.properties = this.unmodifiable ? (sp.isEmpty() ? Collections.emptyMap() : CollectionUtils.u((Map)sp)) : sp;
    }

    public void addWarning(String msg, Object ... args) {
        AssertionUtils.assertArgsNotNull((String)"msg", (Object)msg, (String)"args", (Object)args);
        if (this.unmodifiable) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = new LinkedList<String>();
        }
        this.warnings.add(this.warnings.size() + 1 + ": " + Utils.f((String)msg, (Object[])args));
    }

    public void checkForWarnings() {
        if (this.debug && !this.getWarnings().isEmpty()) {
            throw ThrowableUtils.bex((String)("Warnings occurred in session: \n" + StringUtils.join(this.getWarnings(), (String)"\n")), (Object[])new Object[0]);
        }
    }

    public Context getContext() {
        return this.ctx;
    }

    public final Map<String, Object> getSessionProperties() {
        return this.properties;
    }

    public final List<String> getWarnings() {
        return this.warnings == null ? Collections.emptyList() : this.warnings;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"debug", (Object)this.debug);
    }

    public static abstract class Builder {
        private Boolean debug;
        private boolean unmodifiable;
        private Context ctx;
        private ResettableSupplier<LinkedHashMap<String, Object>> properties;

        protected Builder(Context ctx) {
            this.ctx = (Context)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx);
            this.properties = Utils.memr(LinkedHashMap::new);
        }

        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            if (((Class)AssertionUtils.assertArgNotNull((String)"type", type)).isInstance(this)) {
                ((Consumer)AssertionUtils.assertArgNotNull((String)"apply", apply)).accept(type.cast(this));
            }
            return this;
        }

        public abstract ContextSession build();

        public Builder debug(Boolean value) {
            this.debug = value;
            return this;
        }

        public Builder properties(Map<String, Object> value) {
            AssertionUtils.assertArgNotNull((String)"value", value);
            this.properties.reset();
            ((LinkedHashMap)this.properties.get()).putAll(value);
            return this;
        }

        public Builder property(String key, Object value) {
            AssertionUtils.assertArgNotNull((String)"key", (Object)key);
            LinkedHashMap map = (LinkedHashMap)this.properties.get();
            if (value == null) {
                map.remove(key);
            } else {
                map.put(key, value);
            }
            return this;
        }

        public Builder unmodifiable() {
            this.unmodifiable = true;
            return this;
        }
    }
}

