/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicDatePart
extends BasicPart {
    private final ZonedDateTime value;
    private final Supplier<ZonedDateTime> supplier;

    public static BasicDatePart of(String name, Supplier<ZonedDateTime> value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicDatePart(name, value);
    }

    public static BasicDatePart of(String name, ZonedDateTime value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicDatePart(name, value);
    }

    public BasicDatePart(String name, String value) {
        super(name, value);
        this.value = Utils.e(value) ? null : ZonedDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(value)).truncatedTo(ChronoUnit.SECONDS);
        this.supplier = null;
    }

    public BasicDatePart(String name, Supplier<ZonedDateTime> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicDatePart(String name, ZonedDateTime value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public FluentZonedDateTimeAssertion<BasicDatePart> assertZonedDateTime() {
        return new FluentZonedDateTimeAssertion<BasicDatePart>(this.value(), this);
    }

    public Optional<ZonedDateTime> asZonedDateTime() {
        return Utils.opt(this.toZonedDateTime());
    }

    @Override
    public String getValue() {
        ZonedDateTime v = this.value();
        return v == null ? null : DateTimeFormatter.ISO_DATE_TIME.format(v);
    }

    public ZonedDateTime orElse(ZonedDateTime other) {
        ZonedDateTime x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public ZonedDateTime toZonedDateTime() {
        return this.value();
    }

    private ZonedDateTime value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

