/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class PrimitiveSizes {
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int UUID = 16;

    private PrimitiveSizes() {
    }

    public static int sizeOfString(String str) {
        return 2 + PrimitiveSizes.encodedUTF8Length(str);
    }

    public static int sizeOfLongString(String s) {
        return 4 + PrimitiveSizes.encodedUTF8Length(s);
    }

    public static int sizeOfStringList(List<String> l) {
        int size = 2;
        for (String str : l) {
            size += PrimitiveSizes.sizeOfString(str);
        }
        return size;
    }

    public static int sizeOfBytes(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    public static int sizeOfBytes(ByteBuffer bytes) {
        return 4 + (bytes == null ? 0 : bytes.remaining());
    }

    public static int sizeOfShortBytes(byte[] bytes) {
        return 2 + bytes.length;
    }

    public static int sizeOfShortBytes(ByteBuffer bytes) {
        return 2 + (bytes == null ? 0 : bytes.remaining());
    }

    public static int sizeOfStringMap(Map<String, String> m) {
        int size = 2;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            size += PrimitiveSizes.sizeOfString(entry.getKey());
            size += PrimitiveSizes.sizeOfString(entry.getValue());
        }
        return size;
    }

    public static int sizeOfStringMultimap(Map<String, List<String>> m) {
        int size = 2;
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            size += PrimitiveSizes.sizeOfString(entry.getKey());
            size += PrimitiveSizes.sizeOfStringList(entry.getValue());
        }
        return size;
    }

    public static int sizeOfBytesMap(Map<String, ByteBuffer> m) {
        int size = 2;
        for (Map.Entry<String, ByteBuffer> entry : m.entrySet()) {
            size += PrimitiveSizes.sizeOfString(entry.getKey());
            size += PrimitiveSizes.sizeOfBytes(entry.getValue());
        }
        return size;
    }

    static int encodedUTF8Length(String st) {
        int length = 0;
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (Character.isHighSurrogate(c)) {
                char c1;
                if (i < st.length() - 1 && Character.isLowSurrogate(c1 = st.charAt(i + 1))) {
                    length += 4;
                    ++i;
                    continue;
                }
                ++length;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                ++length;
                continue;
            }
            if (c <= '\u007f') {
                ++length;
                continue;
            }
            if (c <= '\u07ff') {
                length += 2;
                continue;
            }
            length += 3;
        }
        return length;
    }

    public static int sizeOfInet(InetSocketAddress address) {
        return PrimitiveSizes.sizeOfInetAddr(address.getAddress()) + 4;
    }

    public static int sizeOfInetAddr(InetAddress address) {
        byte[] raw = address.getAddress();
        return 1 + raw.length;
    }
}

