/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttribute;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPConstraints;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPControl;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPEntry;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPException;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPExtendedOperation;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPModification;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPModificationSet;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPSearchConstraints;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPSearchResults;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPSocketFactory;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPToJavaSocketFactory;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPConnection {
    public static final int DEREF_NEVER = DereferencePolicy.NEVER.intValue();
    public static final int DEREF_SEARCHING = DereferencePolicy.SEARCHING.intValue();
    public static final int DEREF_FINDING = DereferencePolicy.FINDING.intValue();
    public static final int DEREF_ALWAYS = DereferencePolicy.ALWAYS.intValue();
    public static final int SCOPE_BASE = 0;
    public static final int SCOPE_ONE = 1;
    public static final int SCOPE_SUB = 2;
    @NotNull
    private volatile com.unboundid.ldap.sdk.LDAPConnection conn;
    @NotNull
    private LDAPConstraints constraints;
    @Nullable
    private LDAPControl[] responseControls;
    @NotNull
    private LDAPSearchConstraints searchConstraints;
    @Nullable
    private LDAPSocketFactory socketFactory;
    @Nullable
    private String authDN;
    @Nullable
    private String authPW;

    public LDAPConnection() {
        this(null);
    }

    public LDAPConnection(@Nullable LDAPSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        this.conn = socketFactory == null ? new com.unboundid.ldap.sdk.LDAPConnection() : new com.unboundid.ldap.sdk.LDAPConnection(new LDAPToJavaSocketFactory(socketFactory));
        this.authDN = null;
        this.authPW = null;
        this.constraints = new LDAPConstraints();
        this.searchConstraints = new LDAPSearchConstraints();
    }

    protected void finalize() throws Throwable {
        this.conn.close();
        super.finalize();
    }

    @NotNull
    public com.unboundid.ldap.sdk.LDAPConnection getSDKConnection() {
        return this.conn;
    }

    @Nullable
    public String getHost() {
        return this.conn.getConnectedAddress();
    }

    public int getPort() {
        return this.conn.getConnectedPort();
    }

    @Nullable
    public String getAuthenticationDN() {
        return this.authDN;
    }

    @Nullable
    public String getAuthenticationPassword() {
        return this.authPW;
    }

    public int getConnectTimeout() {
        int connectTimeoutMillis = this.conn.getConnectionOptions().getConnectTimeoutMillis();
        if (connectTimeoutMillis > 0) {
            return Math.max(1, connectTimeoutMillis / 1000);
        }
        return 0;
    }

    public void setConnectTimeout(int timeout) {
        LDAPConnectionOptions options = this.conn.getConnectionOptions();
        if (timeout > 0) {
            options.setConnectTimeoutMillis(1000 * timeout);
        } else {
            options.setConnectTimeoutMillis(0);
        }
        this.conn.setConnectionOptions(options);
    }

    @Nullable
    public LDAPSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(@Nullable LDAPSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        if (socketFactory == null) {
            this.conn.setSocketFactory(null);
        } else {
            this.conn.setSocketFactory(new LDAPToJavaSocketFactory(socketFactory));
        }
    }

    @NotNull
    public LDAPConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(@Nullable LDAPConstraints constraints) {
        this.constraints = constraints == null ? new LDAPConstraints() : constraints;
    }

    @NotNull
    public LDAPSearchConstraints getSearchConstraints() {
        return this.searchConstraints;
    }

    public void setSearchConstraints(@Nullable LDAPSearchConstraints searchConstraints) {
        this.searchConstraints = searchConstraints == null ? new LDAPSearchConstraints() : searchConstraints;
    }

    @Nullable
    public LDAPControl[] getResponseControls() {
        return this.responseControls;
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public void connect(@NotNull String host, int port) throws LDAPException {
        this.authDN = null;
        this.authPW = null;
        this.responseControls = null;
        try {
            this.conn.close();
            this.conn = this.socketFactory == null ? new com.unboundid.ldap.sdk.LDAPConnection(host, port) : new com.unboundid.ldap.sdk.LDAPConnection(new LDAPToJavaSocketFactory(this.socketFactory), host, port);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le);
        }
    }

    public void connect(@NotNull String host, int port, @Nullable String dn, @Nullable String password) throws LDAPException {
        this.connect(3, host, port, dn, password, null);
    }

    public void connect(@NotNull String host, int port, @Nullable String dn, @Nullable String password, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.connect(3, host, port, dn, password, constraints);
    }

    public void connect(int version, @NotNull String host, int port, @Nullable String dn, @Nullable String password) throws LDAPException {
        this.connect(version, host, port, dn, password, null);
    }

    public void connect(int version, @NotNull String host, int port, @Nullable String dn, @Nullable String password, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.connect(host, port);
        try {
            if (dn != null && password != null) {
                this.bind(version, dn, password, constraints);
            }
        }
        catch (LDAPException le) {
            this.conn.close();
            throw le;
        }
    }

    public void disconnect() throws LDAPException {
        this.authDN = null;
        this.authPW = null;
        this.conn.close();
        this.conn = this.socketFactory == null ? new com.unboundid.ldap.sdk.LDAPConnection() : new com.unboundid.ldap.sdk.LDAPConnection(new LDAPToJavaSocketFactory(this.socketFactory));
    }

    public void reconnect() throws LDAPException {
        String host = this.getHost();
        int port = this.getPort();
        String dn = this.authDN;
        String pw = this.authPW;
        if (dn == null || pw == null) {
            this.connect(host, port);
        } else {
            this.connect(host, port, dn, pw);
        }
    }

    public void abandon(int id) throws LDAPException {
        try {
            this.conn.abandon(InternalSDKHelper.createAsyncRequestID(id, this.conn), this.getControls(null));
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le);
        }
    }

    public void abandon(@NotNull LDAPSearchResults searchResults) throws LDAPException {
        try {
            AsyncRequestID requestID = searchResults.getAsyncRequestID();
            if (requestID == null) {
                throw new LDAPException("The search request has not been sent to the server", 89);
            }
            searchResults.setAbandoned();
            this.conn.abandon(requestID);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le);
        }
    }

    public void add(@NotNull LDAPEntry entry) throws LDAPException {
        this.add(entry, null);
    }

    public void add(@NotNull LDAPEntry entry, @Nullable LDAPConstraints constraints) throws LDAPException {
        AddRequest addRequest = new AddRequest(entry.toEntry());
        this.update(addRequest, constraints);
        try {
            LDAPResult result = this.conn.add(addRequest);
            this.setResponseControls(result);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    public void authenticate(@Nullable String dn, @Nullable String password) throws LDAPException {
        this.bind(3, dn, password, null);
    }

    public void authenticate(@Nullable String dn, @Nullable String password, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.bind(3, dn, password, constraints);
    }

    public void authenticate(int version, @Nullable String dn, @Nullable String password) throws LDAPException {
        this.bind(version, dn, password, null);
    }

    public void authenticate(int version, @Nullable String dn, @Nullable String password, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.bind(version, dn, password, constraints);
    }

    public void bind(@Nullable String dn, @Nullable String password) throws LDAPException {
        this.bind(3, dn, password, null);
    }

    public void bind(@Nullable String dn, @Nullable String password, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.bind(3, dn, password, constraints);
    }

    public void bind(int version, @Nullable String dn, @Nullable String password) throws LDAPException {
        this.bind(version, dn, password, null);
    }

    public void bind(int version, @Nullable String dn, @Nullable String password, @Nullable LDAPConstraints constraints) throws LDAPException {
        SimpleBindRequest bindRequest = new SimpleBindRequest(dn, password, this.getControls(constraints));
        this.authDN = null;
        this.authPW = null;
        try {
            BindResult bindResult = this.conn.bind(bindRequest);
            this.setResponseControls(bindResult);
            if (bindResult.getResultCode() == ResultCode.SUCCESS) {
                this.authDN = dn;
                this.authPW = password;
            }
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    public boolean compare(@NotNull String dn, @NotNull LDAPAttribute attribute) throws LDAPException {
        return this.compare(dn, attribute, null);
    }

    public boolean compare(@NotNull String dn, @NotNull LDAPAttribute attribute, @Nullable LDAPConstraints constraints) throws LDAPException {
        CompareRequest compareRequest = new CompareRequest(dn, attribute.getName(), attribute.getByteValueArray()[0]);
        this.update(compareRequest, constraints);
        try {
            CompareResult result = this.conn.compare(compareRequest);
            this.setResponseControls(result);
            return result.compareMatched();
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    public void delete(@NotNull String dn) throws LDAPException {
        this.delete(dn, null);
    }

    public void delete(@NotNull String dn, @Nullable LDAPConstraints constraints) throws LDAPException {
        DeleteRequest deleteRequest = new DeleteRequest(dn);
        this.update(deleteRequest, constraints);
        try {
            LDAPResult result = this.conn.delete(deleteRequest);
            this.setResponseControls(result);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    @NotNull
    public LDAPExtendedOperation extendedOperation(@NotNull LDAPExtendedOperation extendedOperation) throws LDAPException {
        return this.extendedOperation(extendedOperation, null);
    }

    @NotNull
    public LDAPExtendedOperation extendedOperation(@NotNull LDAPExtendedOperation extendedOperation, @Nullable LDAPConstraints constraints) throws LDAPException {
        ExtendedRequest extendedRequest = new ExtendedRequest(extendedOperation.getID(), new ASN1OctetString(extendedOperation.getValue()), this.getControls(constraints));
        try {
            ExtendedResult result = this.conn.processExtendedOperation(extendedRequest);
            this.setResponseControls(result);
            if (result.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(result.getDiagnosticMessage(), result.getResultCode().intValue(), result.getDiagnosticMessage(), result.getMatchedDN());
            }
            ASN1OctetString value = result.getValue();
            byte[] valueBytes = value == null ? null : value.getValue();
            return new LDAPExtendedOperation(result.getOID(), valueBytes);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    public void modify(@NotNull String dn, @NotNull LDAPModification mod) throws LDAPException {
        this.modify(dn, new LDAPModification[]{mod}, null);
    }

    public void modify(@NotNull String dn, @NotNull LDAPModification[] mods) throws LDAPException {
        this.modify(dn, mods, null);
    }

    public void modify(@NotNull String dn, @NotNull LDAPModification mod, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.modify(dn, new LDAPModification[]{mod}, constraints);
    }

    public void modify(@NotNull String dn, @NotNull LDAPModification[] mods, @Nullable LDAPConstraints constraints) throws LDAPException {
        Modification[] m = new Modification[mods.length];
        for (int i = 0; i < mods.length; ++i) {
            m[i] = mods[i].toModification();
        }
        ModifyRequest modifyRequest = new ModifyRequest(dn, m);
        this.update(modifyRequest, constraints);
        try {
            LDAPResult result = this.conn.modify(modifyRequest);
            this.setResponseControls(result);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    public void modify(@NotNull String dn, @NotNull LDAPModificationSet mods) throws LDAPException {
        this.modify(dn, mods.toArray(), null);
    }

    public void modify(@NotNull String dn, @NotNull LDAPModificationSet mods, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.modify(dn, mods.toArray(), constraints);
    }

    @NotNull
    public LDAPEntry read(@NotNull String dn) throws LDAPException {
        return this.read(dn, null, null);
    }

    @NotNull
    public LDAPEntry read(@NotNull String dn, @Nullable LDAPSearchConstraints constraints) throws LDAPException {
        return this.read(dn, null, constraints);
    }

    @NotNull
    public LDAPEntry read(@NotNull String dn, @Nullable String[] attrs) throws LDAPException {
        return this.read(dn, attrs, null);
    }

    @NotNull
    public LDAPEntry read(@NotNull String dn, @Nullable String[] attrs, @Nullable LDAPSearchConstraints constraints) throws LDAPException {
        Filter filter = Filter.createORFilter(Filter.createPresenceFilter("objectClass"), Filter.createEqualityFilter("objectClass", "ldapSubentry"));
        SearchRequest searchRequest = new SearchRequest(dn, SearchScope.BASE, filter, attrs);
        this.update(searchRequest, constraints);
        try {
            SearchResult searchResult = this.conn.search(searchRequest);
            this.setResponseControls(searchResult);
            if (searchResult.getEntryCount() != 1) {
                throw new LDAPException(null, 94);
            }
            return new LDAPEntry(searchResult.getSearchEntries().get(0));
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    public void rename(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(dn, newRDN, null, deleteOldRDN, null);
    }

    public void rename(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN, @Nullable LDAPConstraints constraints) throws LDAPException {
        this.rename(dn, newRDN, null, deleteOldRDN, constraints);
    }

    public void rename(@NotNull String dn, @NotNull String newRDN, @Nullable String newParentDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(dn, newRDN, newParentDN, deleteOldRDN, null);
    }

    public void rename(@NotNull String dn, @NotNull String newRDN, @Nullable String newParentDN, boolean deleteOldRDN, @Nullable LDAPConstraints constraints) throws LDAPException {
        ModifyDNRequest modifyDNRequest = new ModifyDNRequest(dn, newRDN, deleteOldRDN, newParentDN);
        this.update(modifyDNRequest, constraints);
        try {
            LDAPResult result = this.conn.modifyDN(modifyDNRequest);
            this.setResponseControls(result);
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    @NotNull
    public LDAPSearchResults search(@NotNull String baseDN, int scope, @NotNull String filter, @Nullable String[] attributes, boolean typesOnly) throws LDAPException {
        return this.search(baseDN, scope, filter, attributes, typesOnly, null);
    }

    @NotNull
    public LDAPSearchResults search(@NotNull String baseDN, int scope, @NotNull String filter, @Nullable String[] attributes, boolean typesOnly, @Nullable LDAPSearchConstraints constraints) throws LDAPException {
        LDAPSearchConstraints c = constraints == null ? this.searchConstraints : constraints;
        LDAPSearchResults results = new LDAPSearchResults(c.getTimeLimit());
        try {
            SearchRequest searchRequest = new SearchRequest((SearchResultListener)results, baseDN, SearchScope.valueOf(scope), filter, attributes);
            searchRequest.setDerefPolicy(DereferencePolicy.valueOf(c.getDereference()));
            searchRequest.setSizeLimit(c.getMaxResults());
            searchRequest.setTimeLimitSeconds(c.getServerTimeLimit());
            searchRequest.setTypesOnly(typesOnly);
            this.update(searchRequest, constraints);
            results.setAsyncRequestID(this.conn.asyncSearch(searchRequest));
            return results;
        }
        catch (com.unboundid.ldap.sdk.LDAPException le) {
            Debug.debugException(le);
            this.setResponseControls(le);
            throw new LDAPException(le);
        }
    }

    @NotNull
    private Control[] getControls(@Nullable LDAPConstraints c) {
        Control[] controls = null;
        if (c != null) {
            controls = LDAPControl.toControls(c.getServerControls());
        } else if (this.constraints != null) {
            controls = LDAPControl.toControls(this.constraints.getServerControls());
        }
        if (controls == null) {
            return new Control[0];
        }
        return controls;
    }

    private void update(@NotNull UpdatableLDAPRequest request, @Nullable LDAPConstraints constraints) {
        LDAPConstraints c = constraints == null ? this.constraints : constraints;
        request.setControls(LDAPControl.toControls(c.getServerControls()));
        request.setResponseTimeoutMillis(c.getTimeLimit());
        request.setFollowReferrals(c.getReferrals());
    }

    private void setResponseControls(@NotNull LDAPResult ldapResult) {
        this.responseControls = ldapResult.hasResponseControl() ? LDAPControl.toLDAPControls(ldapResult.getResponseControls()) : null;
    }

    private void setResponseControls(@NotNull com.unboundid.ldap.sdk.LDAPException ldapException) {
        this.responseControls = ldapException.hasResponseControl() ? LDAPControl.toLDAPControls(ldapException.getResponseControls()) : null;
    }
}

