/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import java.util.List;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategy;
import org.apache.james.modules.blobstore.validation.StorageStrategyAggregate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class RegisterStorageStrategyCommandHandler
implements CommandHandler<RegisterStorageStrategy> {
    static final String STORAGE_STRATEGY_CONFIGURATION_AGGREGATE_KEY = "BlobStoreStorageStrategyConfiguration";
    public static final AggregateId AGGREGATE_ID = () -> "BlobStoreStorageStrategyConfiguration";
    private final EventStore eventStore;

    public RegisterStorageStrategyCommandHandler(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public Class<RegisterStorageStrategy> handledClass() {
        return RegisterStorageStrategy.class;
    }

    public Publisher<List<EventWithState>> handle(RegisterStorageStrategy command) {
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate(AGGREGATE_ID)).map(history -> StorageStrategyAggregate.load(AGGREGATE_ID, history)).map(aggregate -> aggregate.registerStorageStrategy(command));
    }
}

