/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.metric.SchemaEngineCachedMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.CachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.flush.Scheduler;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.IReleaseFlushStrategy;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.ReleaseFlushStrategyNumBasedImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.ReleaseFlushStrategySizeBasedImpl;
import org.apache.iotdb.db.utils.concurrent.FiniteSemaphore;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseFlushMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseFlushMonitor.class);
    private static final double FREE_FLUSH_PROPORTION = 0.2;
    private static final int MONITOR_INETRVAL_MILLISECONDS = 5000;
    private static final int MAX_WAITING_TIME_WHEN_RELEASING = 3000;
    private final Map<Integer, RecordList> regionToTraverserTime = new ConcurrentHashMap<Integer, RecordList>();
    private final Map<Integer, CachedMTreeStore> regionToStoreMap = new ConcurrentHashMap<Integer, CachedMTreeStore>();
    private final Set<Integer> flushingRegionSet = new CopyOnWriteArraySet<Integer>();
    private CachedSchemaEngineStatistics engineStatistics;
    private SchemaEngineCachedMetric engineMetric;
    private IReleaseFlushStrategy releaseFlushStrategy;
    private final Object blockObject = new Object();
    private ScheduledExecutorService flushMonitor;
    private ExecutorService releaseMonitor;
    private FiniteSemaphore releaseSemaphore;
    private Scheduler scheduler;

    public void registerCachedMTreeStore(CachedMTreeStore store) {
        this.regionToStoreMap.put(store.getRegionStatistics().getSchemaRegionId(), store);
        this.regionToTraverserTime.put(store.getRegionStatistics().getSchemaRegionId(), new RecordList());
    }

    public void clearCachedMTreeStore(CachedMTreeStore store) {
        this.regionToStoreMap.remove(store.getRegionStatistics().getSchemaRegionId());
        this.regionToTraverserTime.remove(store.getRegionStatistics().getSchemaRegionId());
    }

    public void init(ISchemaEngineStatistics engineStatistics) {
        this.releaseSemaphore = new FiniteSemaphore(2, 0);
        this.engineStatistics = engineStatistics.getAsCachedSchemaEngineStatistics();
        this.releaseFlushStrategy = IoTDBDescriptor.getInstance().getConfig().getCachedMNodeSizeInPBTreeMode() >= 0 ? new ReleaseFlushStrategyNumBasedImpl(this.engineStatistics) : new ReleaseFlushStrategySizeBasedImpl(this.engineStatistics);
        this.scheduler = new Scheduler(this.regionToStoreMap, this.flushingRegionSet, this.releaseFlushStrategy);
        this.releaseMonitor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.PBTREE_RELEASE_MONITOR.getName());
        this.flushMonitor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PBTREE_FLUSH_MONITOR.getName());
        this.releaseMonitor.submit(() -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.releaseSemaphore.acquire();
                    if (!this.releaseFlushStrategy.isExceedReleaseThreshold()) continue;
                    this.scheduler.scheduleRelease(false);
                    if (this.releaseFlushStrategy.isExceedReleaseThreshold()) {
                        this.scheduler.scheduleFlushAll();
                        this.regionToTraverserTime.values().forEach(rec$ -> ((RecordList)rec$).clear());
                    }
                    Object object = this.blockObject;
                    synchronized (object) {
                        this.blockObject.notifyAll();
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                logger.info("ReleaseTaskMonitor thread is interrupted.");
                Thread.currentThread().interrupt();
            }
        });
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.flushMonitor, () -> {
            if (this.releaseFlushStrategy.isExceedReleaseThreshold()) {
                this.releaseSemaphore.release();
            } else {
                this.scheduler.scheduleFlush(this.getRegionsToFlush(System.currentTimeMillis()));
            }
        }, (long)5000L, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void setEngineMetric(SchemaEngineCachedMetric engineMetric) {
        this.engineMetric = engineMetric;
    }

    public void ensureMemoryStatus() {
        if (this.releaseFlushStrategy.isExceedReleaseThreshold()) {
            this.releaseSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIfReleasing() {
        Object object = this.blockObject;
        synchronized (object) {
            try {
                this.blockObject.wait(3000L);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupt because the release task and flush task did not finish within {} milliseconds.", (Object)3000);
                Thread.currentThread().interrupt();
            }
        }
    }

    public RecordNode recordTraverserTime(int regionId) {
        return this.regionToTraverserTime.get(regionId).createAndAddToTail();
    }

    @TestOnly
    public void initRecordList(int regionId) {
        this.regionToTraverserTime.computeIfAbsent(regionId, k -> new RecordList());
    }

    public List<Integer> getRegionsToFlush(long windowsEndTime) {
        long windowsStartTime = windowsEndTime - 5000L;
        ArrayList<Pair> regionAndFreeTimeList = new ArrayList<Pair>();
        for (Map.Entry<Integer, RecordList> entry : this.regionToTraverserTime.entrySet()) {
            RecordNode recordNode;
            int regionId = entry.getKey();
            long traverserEndTime = windowsStartTime;
            long traverserFreeTime = 0L;
            RecordList recordList = entry.getValue();
            Iterator iterator = recordList.iterator();
            while (iterator.hasNext() && (recordNode = (RecordNode)iterator.next()).startTime <= windowsEndTime) {
                if (recordNode.startTime > traverserEndTime) {
                    traverserFreeTime += recordNode.startTime - traverserEndTime;
                    traverserEndTime = recordNode.endTime;
                } else if (recordNode.endTime > traverserEndTime) {
                    traverserEndTime = recordNode.endTime;
                }
                if (recordNode.endTime < windowsStartTime) {
                    iterator.remove();
                    continue;
                }
                if (recordNode.endTime < windowsEndTime) continue;
                break;
            }
            if (traverserEndTime < windowsEndTime) {
                traverserFreeTime += windowsEndTime - traverserEndTime;
            }
            if (!((double)traverserFreeTime > 1000.0)) continue;
            regionAndFreeTimeList.add(new Pair((Object)regionId, (Object)traverserFreeTime));
        }
        regionAndFreeTimeList.sort(Comparator.comparing(o -> (Long)o.right).reversed());
        return regionAndFreeTimeList.stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    @TestOnly
    public void forceFlushAndRelease() {
        while (true) {
            boolean needFlush = false;
            for (CachedMTreeStore store : this.regionToStoreMap.values()) {
                if (store.getMemoryManager().getBufferNodeNum() <= 0L) continue;
                needFlush = true;
                break;
            }
            if (!needFlush) break;
            this.scheduler.scheduleFlushAll().join();
            this.scheduler.scheduleRelease(true);
        }
    }

    public void clear() {
        if (this.releaseMonitor != null) {
            this.releaseMonitor.shutdownNow();
            while (!this.releaseMonitor.isTerminated()) {
            }
            this.releaseMonitor = null;
        }
        if (this.flushMonitor != null) {
            this.flushMonitor.shutdownNow();
            while (!this.flushMonitor.isTerminated()) {
            }
            this.flushMonitor = null;
        }
        if (this.scheduler != null) {
            this.scheduler.clear();
            while (!this.scheduler.isTerminated()) {
            }
            this.scheduler = null;
        }
        this.regionToStoreMap.clear();
        this.flushingRegionSet.clear();
        this.regionToTraverserTime.clear();
        this.releaseFlushStrategy = null;
        this.engineStatistics = null;
        this.releaseSemaphore = null;
        this.engineMetric = null;
    }

    public int getActiveWorkerNum() {
        return this.scheduler.getActiveWorkerNum();
    }

    private ReleaseFlushMonitor() {
    }

    public static ReleaseFlushMonitor getInstance() {
        return ReleaseFlushMonitorHolder.INSTANCE;
    }

    @NotThreadSafe
    private static class RecordList {
        private final RecordNode head = new RecordNode();
        private final RecordNode tail = new RecordNode();

        private RecordList() {
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }

        private synchronized RecordNode createAndAddToTail() {
            RecordNode recordNode = new RecordNode();
            recordNode.prev = this.tail.prev;
            recordNode.next = this.tail;
            this.tail.prev.next = recordNode;
            this.tail.prev = recordNode;
            return recordNode;
        }

        private synchronized void remove(RecordNode recordNode) {
            recordNode.prev.next = recordNode.next;
            recordNode.next.prev = recordNode.prev;
            recordNode.prev = null;
            recordNode.next = null;
        }

        private synchronized void clear() {
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }

        private Iterator<RecordNode> iterator() {
            return new Iterator<RecordNode>(){
                private RecordNode next = null;
                private RecordNode cur = RecordList.access$900(this);

                @Override
                public boolean hasNext() {
                    if (this.next == null && this.cur.next != tail) {
                        this.next = this.cur.next;
                    }
                    return this.next != null;
                }

                @Override
                public RecordNode next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.cur = this.next;
                    this.next = null;
                    return this.cur;
                }

                @Override
                public void remove() {
                    if (this.next == null && this.cur.next != tail) {
                        this.next = this.cur.next;
                    }
                    this.remove(this.cur);
                }
            };
        }

        static /* synthetic */ RecordNode access$900(RecordList x0) {
            return x0.head;
        }
    }

    public static class RecordNode {
        private RecordNode prev = null;
        private RecordNode next = null;
        private Long startTime = System.currentTimeMillis();
        private Long endTime = Long.MAX_VALUE;

        @TestOnly
        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }
    }

    private static class ReleaseFlushMonitorHolder {
        private static final ReleaseFlushMonitor INSTANCE = new ReleaseFlushMonitor();

        private ReleaseFlushMonitorHolder() {
        }
    }
}

