/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.BytesUtils;

public class SubString2ColumnTransformer
extends BinaryColumnTransformer {
    public SubString2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        Type rightType = this.rightTransformer.getType();
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.transform(leftColumn, rightColumn, builder, rightType, i);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        Type rightType = this.rightTransformer.getType();
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.transform(leftColumn, rightColumn, builder, rightType, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(Column leftColumn, Column rightColumn, ColumnBuilder builder, Type rightType, int i) {
        String currentValue = leftColumn.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
        int beginPosition = rightType.getInt(rightColumn, i);
        if (beginPosition > currentValue.length()) {
            throw new SemanticException("Argument exception,the scalar function substring beginPosition must not be greater than the string length");
        }
        int maxMin = Math.max(1, beginPosition);
        currentValue = currentValue.substring(maxMin - 1);
        builder.writeBinary(BytesUtils.valueOf((String)currentValue));
    }
}

