/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.Type;

public final class Insert
extends Statement {
    public static final String ROWS = "rows";
    public static final Type ROWS_TYPE = LongType.INT64;
    public static final TsTableColumnCategory ROWS_CATEGORY = TsTableColumnCategory.FIELD;
    private final Table table;
    private final Query query;
    @Nullable
    private final List<Identifier> columns;

    public Insert(Table table, Query query) {
        super(null);
        this.table = Objects.requireNonNull(table, "target is null");
        this.columns = null;
        this.query = Objects.requireNonNull(query, "query is null");
    }

    public Insert(Table table, List<Identifier> columns, Query query) {
        super(null);
        this.table = Objects.requireNonNull(table, "target is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    public Table getTable() {
        return this.table;
    }

    public QualifiedName getTarget() {
        return this.table.getName();
    }

    public Optional<List<Identifier>> getColumns() {
        return Optional.ofNullable(this.columns);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.columns, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Insert o = (Insert)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.columns, o.columns) && Objects.equals(this.query, o.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("columns", this.columns).add("query", (Object)this.query).toString();
    }
}

