/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class StructureField
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=101");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14844");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14800");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15065");
    private final String name;
    private final LocalizedText description;
    private final NodeId dataType;
    private final Integer valueRank;
    private final UInteger[] arrayDimensions;
    private final UInteger maxStringLength;
    private final Boolean isOptional;

    public StructureField(String name, LocalizedText description, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UInteger maxStringLength, Boolean isOptional) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.maxStringLength = maxStringLength;
        this.isOptional = isOptional;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public String getName() {
        return this.name;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public UInteger getMaxStringLength() {
        return this.maxStringLength;
    }

    public Boolean getIsOptional() {
        return this.isOptional;
    }

    protected StructureField(StructureFieldBuilder<?, ?> b) {
        super(b);
        this.name = ((StructureFieldBuilder)b).name;
        this.description = ((StructureFieldBuilder)b).description;
        this.dataType = ((StructureFieldBuilder)b).dataType;
        this.valueRank = ((StructureFieldBuilder)b).valueRank;
        this.arrayDimensions = ((StructureFieldBuilder)b).arrayDimensions;
        this.maxStringLength = ((StructureFieldBuilder)b).maxStringLength;
        this.isOptional = ((StructureFieldBuilder)b).isOptional;
    }

    public static StructureFieldBuilder<?, ?> builder() {
        return new StructureFieldBuilderImpl();
    }

    public StructureFieldBuilder<?, ?> toBuilder() {
        return new StructureFieldBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructureField)) {
            return false;
        }
        StructureField other = (StructureField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$valueRank = this.getValueRank();
        Integer other$valueRank = other.getValueRank();
        if (this$valueRank == null ? other$valueRank != null : !((Object)this$valueRank).equals(other$valueRank)) {
            return false;
        }
        Boolean this$isOptional = this.getIsOptional();
        Boolean other$isOptional = other.getIsOptional();
        if (this$isOptional == null ? other$isOptional != null : !((Object)this$isOptional).equals(other$isOptional)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LocalizedText this$description = this.getDescription();
        LocalizedText other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        NodeId this$dataType = this.getDataType();
        NodeId other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArrayDimensions(), other.getArrayDimensions())) {
            return false;
        }
        UInteger this$maxStringLength = this.getMaxStringLength();
        UInteger other$maxStringLength = other.getMaxStringLength();
        return !(this$maxStringLength == null ? other$maxStringLength != null : !((Object)this$maxStringLength).equals(other$maxStringLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StructureField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $valueRank = this.getValueRank();
        result = result * 59 + ($valueRank == null ? 43 : ((Object)$valueRank).hashCode());
        Boolean $isOptional = this.getIsOptional();
        result = result * 59 + ($isOptional == null ? 43 : ((Object)$isOptional).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LocalizedText $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        NodeId $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArrayDimensions());
        UInteger $maxStringLength = this.getMaxStringLength();
        result = result * 59 + ($maxStringLength == null ? 43 : ((Object)$maxStringLength).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StructureField(name=" + this.getName() + ", description=" + this.getDescription() + ", dataType=" + this.getDataType() + ", valueRank=" + this.getValueRank() + ", arrayDimensions=" + Arrays.deepToString(this.getArrayDimensions()) + ", maxStringLength=" + this.getMaxStringLength() + ", isOptional=" + this.getIsOptional() + ")";
    }

    private static final class StructureFieldBuilderImpl
    extends StructureFieldBuilder<StructureField, StructureFieldBuilderImpl> {
        private StructureFieldBuilderImpl() {
        }

        @Override
        protected StructureFieldBuilderImpl self() {
            return this;
        }

        @Override
        public StructureField build() {
            return new StructureField(this);
        }
    }

    public static abstract class StructureFieldBuilder<C extends StructureField, B extends StructureFieldBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String name;
        private LocalizedText description;
        private NodeId dataType;
        private Integer valueRank;
        private UInteger[] arrayDimensions;
        private UInteger maxStringLength;
        private Boolean isOptional;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            StructureFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(StructureField instance, StructureFieldBuilder<?, ?> b) {
            b.name(instance.name);
            b.description(instance.description);
            b.dataType(instance.dataType);
            b.valueRank(instance.valueRank);
            b.arrayDimensions(instance.arrayDimensions);
            b.maxStringLength(instance.maxStringLength);
            b.isOptional(instance.isOptional);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B description(LocalizedText description) {
            this.description = description;
            return (B)this.self();
        }

        public B dataType(NodeId dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        public B valueRank(Integer valueRank) {
            this.valueRank = valueRank;
            return (B)this.self();
        }

        public B arrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return (B)this.self();
        }

        public B maxStringLength(UInteger maxStringLength) {
            this.maxStringLength = maxStringLength;
            return (B)this.self();
        }

        public B isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StructureField.StructureFieldBuilder(super=" + super.toString() + ", name=" + this.name + ", description=" + this.description + ", dataType=" + this.dataType + ", valueRank=" + this.valueRank + ", arrayDimensions=" + Arrays.deepToString(this.arrayDimensions) + ", maxStringLength=" + this.maxStringLength + ", isOptional=" + this.isOptional + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<StructureField> {
        @Override
        public Class<StructureField> getType() {
            return StructureField.class;
        }

        @Override
        public StructureField decode(SerializationContext context, UaDecoder decoder) {
            String name = decoder.readString("Name");
            LocalizedText description = decoder.readLocalizedText("Description");
            NodeId dataType = decoder.readNodeId("DataType");
            Integer valueRank = decoder.readInt32("ValueRank");
            UInteger[] arrayDimensions = decoder.readUInt32Array("ArrayDimensions");
            UInteger maxStringLength = decoder.readUInt32("MaxStringLength");
            Boolean isOptional = decoder.readBoolean("IsOptional");
            return new StructureField(name, description, dataType, valueRank, arrayDimensions, maxStringLength, isOptional);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, StructureField value) {
            encoder.writeString("Name", value.getName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeNodeId("DataType", value.getDataType());
            encoder.writeInt32("ValueRank", value.getValueRank());
            encoder.writeUInt32Array("ArrayDimensions", value.getArrayDimensions());
            encoder.writeUInt32("MaxStringLength", value.getMaxStringLength());
            encoder.writeBoolean("IsOptional", value.getIsOptional());
        }
    }
}

