/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational.tvf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.WindowTVFUtils;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgumentChecker;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class CumulateTableFunction
implements TableFunction {
    private static final String DATA_PARAMETER_NAME = "DATA";
    private static final String TIMECOL_PARAMETER_NAME = "TIMECOL";
    private static final String SIZE_PARAMETER_NAME = "SIZE";
    private static final String STEP_PARAMETER_NAME = "STEP";
    private static final String ORIGIN_PARAMETER_NAME = "ORIGIN";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name(DATA_PARAMETER_NAME).rowSemantics().passThroughColumns().build(), ScalarParameterSpecification.builder().name(TIMECOL_PARAMETER_NAME).type(Type.STRING).defaultValue((Object)"time").build(), ScalarParameterSpecification.builder().name(SIZE_PARAMETER_NAME).type(Type.INT64).addChecker(ScalarArgumentChecker.POSITIVE_LONG_CHECKER).build(), ScalarParameterSpecification.builder().name(STEP_PARAMETER_NAME).type(Type.INT64).addChecker(ScalarArgumentChecker.POSITIVE_LONG_CHECKER).build(), ScalarParameterSpecification.builder().name(ORIGIN_PARAMETER_NAME).type(Type.TIMESTAMP).defaultValue((Object)0L).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        long step;
        long size = (Long)((ScalarArgument)arguments.get(SIZE_PARAMETER_NAME)).getValue();
        if (size % (step = ((Long)((ScalarArgument)arguments.get(STEP_PARAMETER_NAME)).getValue()).longValue()) != 0L) {
            throw new UDFException("Cumulative table function requires size must be an integral multiple of step.");
        }
        TableArgument tableArgument = (TableArgument)arguments.get(DATA_PARAMETER_NAME);
        String expectedFieldName = (String)((ScalarArgument)arguments.get(TIMECOL_PARAMETER_NAME)).getValue();
        int requiredIndex = WindowTVFUtils.findColumnIndex(tableArgument, expectedFieldName, Collections.singleton(Type.TIMESTAMP));
        DescribedSchema properColumnSchema = new DescribedSchema.Builder().addField("window_start", Type.TIMESTAMP).addField("window_end", Type.TIMESTAMP).build();
        MapTableFunctionHandle handle = new MapTableFunctionHandle.Builder().addProperty(STEP_PARAMETER_NAME, (Object)step).addProperty(SIZE_PARAMETER_NAME, (Object)size).addProperty(ORIGIN_PARAMETER_NAME, ((ScalarArgument)arguments.get(ORIGIN_PARAMETER_NAME)).getValue()).build();
        return TableFunctionAnalysis.builder().properColumnSchema(properColumnSchema).requireRecordSnapshot(false).requiredColumns(DATA_PARAMETER_NAME, Collections.singletonList(requiredIndex)).handle((TableFunctionHandle)handle).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(final TableFunctionHandle tableFunctionHandle) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new CumulateDataProcessor((Long)((MapTableFunctionHandle)tableFunctionHandle).getProperty(CumulateTableFunction.ORIGIN_PARAMETER_NAME), (Long)((MapTableFunctionHandle)tableFunctionHandle).getProperty(CumulateTableFunction.STEP_PARAMETER_NAME), (Long)((MapTableFunctionHandle)tableFunctionHandle).getProperty(CumulateTableFunction.SIZE_PARAMETER_NAME));
            }
        };
    }

    private static class CumulateDataProcessor
    implements TableFunctionDataProcessor {
        private final long step;
        private final long size;
        private final long origin;
        private long curIndex = 0L;

        public CumulateDataProcessor(long startTime, long step, long size) {
            this.step = step;
            this.size = size;
            this.origin = startTime;
        }

        public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            long timeValue = input.getLong(0);
            if (timeValue >= this.origin) {
                long windowStart = this.origin + (timeValue - this.origin) / this.size * this.size;
                for (long steps = (timeValue - windowStart + this.step) / this.step * this.step; steps <= this.size; steps += this.step) {
                    properColumnBuilders.get(0).writeLong(windowStart);
                    properColumnBuilders.get(1).writeLong(windowStart + steps);
                    passThroughIndexBuilder.writeLong(this.curIndex);
                }
            }
            ++this.curIndex;
        }
    }
}

