/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encrypt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IEncrypt;
import org.apache.tsfile.encrypt.IEncryptor;
import org.apache.tsfile.exception.encrypt.EncryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtils {
    private static final Logger logger = LoggerFactory.getLogger(EncryptUtils.class);
    private static final String encryptClassPrefix = "org.apache.tsfile.encrypt.";
    private static volatile String normalKeyStr;
    private static volatile EncryptParameter encryptParam;
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final int ITERATION_COUNT = 1024;
    private static final int SALT_LENGTH = 16;
    private static final int INT_SIZE = 4;
    private static final int dkLen = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNormalKeyStr() {
        if (normalKeyStr != null) return normalKeyStr;
        Class<EncryptUtils> clazz = EncryptUtils.class;
        synchronized (EncryptUtils.class) {
            if (normalKeyStr != null) return normalKeyStr;
            normalKeyStr = EncryptUtils.getNormalKeyStr(TSFileDescriptor.getInstance().getConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return normalKeyStr;
        }
    }

    public static String getEncryptClass(String encryptType) {
        String classNameRegex = "^(\\p{Alpha}\\w*)(\\.\\p{Alpha}\\w+)+$";
        if (IEncrypt.encryptTypeToClassMap.containsKey(encryptType)) {
            return IEncrypt.encryptTypeToClassMap.get(encryptType);
        }
        if (encryptType.matches(classNameRegex)) {
            IEncrypt.encryptTypeToClassMap.put(encryptType, encryptType);
            return encryptType;
        }
        IEncrypt.encryptTypeToClassMap.put(encryptType, encryptClassPrefix + encryptType);
        return encryptClassPrefix + encryptType;
    }

    public static byte[] getEncryptKeyFromToken(String token, byte[] salt) {
        if (token == null || token.trim().isEmpty()) {
            return EncryptUtils.generateSalt();
        }
        try {
            return EncryptUtils.deriveKeyInternal(token.getBytes(), salt, 1024, 16);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EncryptException("Error deriving key from token", e);
        }
    }

    private static byte[] deriveKeyInternal(byte[] password, byte[] salt, int c, int dkLen) throws NoSuchAlgorithmException, InvalidKeyException {
        int hLen = EncryptUtils.getPRFLength();
        if (dkLen < 1) {
            throw new EncryptException("main key's dkLen must be positive integer: " + dkLen);
        }
        if ((long)dkLen > (long)(Math.pow(2.0, 32.0) - 1.0) * (long)hLen) {
            throw new EncryptException("main key's dkLen is too long: " + dkLen);
        }
        int n = (int)Math.ceil((double)dkLen / (double)hLen);
        int r = dkLen - (n - 1) * hLen;
        byte[] blocks = new byte[n * hLen];
        for (int i = 1; i <= n; ++i) {
            byte[] block = EncryptUtils.F(password, salt, c, i);
            System.arraycopy(block, 0, blocks, (i - 1) * hLen, hLen);
        }
        return Arrays.copyOf(blocks, dkLen);
    }

    private static byte[] F(byte[] password, byte[] salt, int c, int i) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] input = EncryptUtils.concatenate(salt, EncryptUtils.intToBigEndian(i));
        byte[] U = EncryptUtils.prf(password, input);
        byte[] result = (byte[])U.clone();
        for (int j = 2; j <= c; ++j) {
            U = EncryptUtils.prf(password, U);
            EncryptUtils.xorBytes(result, U);
        }
        return result;
    }

    private static byte[] prf(byte[] key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
        hmac.init(new SecretKeySpec(key, HMAC_ALGORITHM));
        return hmac.doFinal(data);
    }

    private static int getPRFLength() throws NoSuchAlgorithmException {
        return Mac.getInstance(HMAC_ALGORITHM).getMacLength();
    }

    public static byte[] generateSalt() {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    private static byte[] intToBigEndian(int i) {
        return new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
    }

    private static void xorBytes(byte[] result, byte[] input) {
        for (int i = 0; i < result.length; ++i) {
            int n = i;
            result[n] = (byte)(result[n] ^ input[i]);
        }
    }

    private static byte[] concatenate(byte[] a, byte[] b) {
        byte[] output = new byte[a.length + b.length];
        System.arraycopy(a, 0, output, 0, a.length);
        System.arraycopy(b, 0, output, a.length, b.length);
        return output;
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] byteArray = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            byteArray[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return byteArray;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static String getNormalKeyStr(TSFileConfig conf) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException("SHA-256 algorithm not found while using SHA-256 to generate data key", e);
        }
        md.update("IoTDB is the best".getBytes());
        md.update(conf.getEncryptKey());
        byte[] data_key = Arrays.copyOfRange(md.digest(), 0, 16);
        data_key = IEncryptor.getEncryptor(conf.getEncryptType(), conf.getEncryptKey()).encrypt(data_key);
        StringBuilder valueStr = new StringBuilder();
        for (byte b : data_key) {
            valueStr.append(b).append(",");
        }
        valueStr.deleteCharAt(valueStr.length() - 1);
        return valueStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptParameter getEncryptParameter() {
        if (encryptParam != null) return encryptParam;
        Class<EncryptUtils> clazz = EncryptUtils.class;
        synchronized (EncryptUtils.class) {
            if (encryptParam != null) return encryptParam;
            encryptParam = EncryptUtils.getEncryptParameter(TSFileDescriptor.getInstance().getConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return encryptParam;
        }
    }

    public static EncryptParameter getEncryptParameter(TSFileConfig conf) {
        byte[] dataEncryptKey;
        String encryptType;
        if (!Objects.equals(conf.getEncryptType(), "UNENCRYPTED") && !Objects.equals(conf.getEncryptType(), "org.apache.tsfile.encrypt.UNENCRYPTED")) {
            MessageDigest md;
            encryptType = conf.getEncryptType();
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptException("SHA-256 algorithm not found while using SHA-256 to generate data key", e);
            }
            md.update("IoTDB is the best".getBytes());
            md.update(conf.getEncryptKey());
            dataEncryptKey = Arrays.copyOfRange(md.digest(), 0, 16);
        } else {
            encryptType = "org.apache.tsfile.encrypt.UNENCRYPTED";
            dataEncryptKey = null;
        }
        return new EncryptParameter(encryptType, dataEncryptKey);
    }

    public static IEncrypt getEncrypt() {
        return EncryptUtils.getEncrypt(TSFileDescriptor.getInstance().getConfig());
    }

    public static IEncrypt getEncrypt(String encryptType, byte[] dataEncryptKey) {
        try {
            String className = EncryptUtils.getEncryptClass(encryptType);
            if (IEncrypt.encryptMap.containsKey(className)) {
                return (IEncrypt)IEncrypt.encryptMap.get(className).newInstance(new Object[]{dataEncryptKey});
            }
            Class<?> encryptTypeClass = Class.forName(className);
            Constructor<?> constructor = encryptTypeClass.getDeclaredConstructor(byte[].class);
            IEncrypt.encryptMap.put(className, constructor);
            return (IEncrypt)constructor.newInstance(new Object[]{dataEncryptKey});
        }
        catch (ClassNotFoundException e) {
            throw new EncryptException("Get encryptor class failed: " + encryptType, e);
        }
        catch (NoSuchMethodException e) {
            throw new EncryptException("Get constructor for encryptor failed: " + encryptType, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EncryptException("New encryptor instance failed: " + encryptType, e);
        }
    }

    public static IEncrypt getEncrypt(TSFileConfig conf) {
        byte[] dataEncryptKey;
        String encryptType;
        if (!Objects.equals(conf.getEncryptType(), "UNENCRYPTED") && !Objects.equals(conf.getEncryptType(), "org.apache.tsfile.encrypt.UNENCRYPTED")) {
            MessageDigest md;
            encryptType = conf.getEncryptType();
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptException("SHA-256 algorithm not found while using SHA-256 to generate data key", e);
            }
            md.update("IoTDB is the best".getBytes());
            md.update(conf.getEncryptKey());
            dataEncryptKey = Arrays.copyOfRange(md.digest(), 0, 16);
        } else {
            encryptType = "org.apache.tsfile.encrypt.UNENCRYPTED";
            dataEncryptKey = null;
        }
        return EncryptUtils.getEncrypt(encryptType, dataEncryptKey);
    }

    public static byte[] getSecondKeyFromStr(String str) {
        String[] strArray = str.split(",");
        byte[] key = new byte[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            key[i] = Byte.parseByte(strArray[i]);
        }
        return key;
    }
}

