/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPollResponseCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPollResponseCache.class);
    private final LoadingCache<CachedSubscriptionPollResponse, ByteBuffer> cache;

    public ByteBuffer serialize(CachedSubscriptionPollResponse response) throws IOException {
        try {
            if (Objects.isNull((Object)response)) {
                throw new IOException("null response when serializing");
            }
            return (ByteBuffer)this.cache.get((Object)response);
        }
        catch (Exception e) {
            LOGGER.warn("SubscriptionEventBinaryCache raised an exception while serializing CachedSubscriptionPollResponse: {}", (Object)response, (Object)e);
            throw new IOException(e);
        }
    }

    public Optional<ByteBuffer> trySerialize(CachedSubscriptionPollResponse response) {
        try {
            if (Objects.isNull((Object)response)) {
                throw new IOException("null response when serializing");
            }
            return Optional.of(this.serialize(response));
        }
        catch (IOException e) {
            LOGGER.warn("Subscription: something unexpected happened when serializing CachedSubscriptionPollResponse: {}", (Object)response, (Object)e);
            return Optional.empty();
        }
    }

    public void invalidate(CachedSubscriptionPollResponse response) {
        if (Objects.isNull((Object)response)) {
            LOGGER.warn("null response when invalidating, skip it");
            return;
        }
        this.cache.invalidate((Object)response);
        response.invalidateByteBuffer();
    }

    public static SubscriptionPollResponseCache getInstance() {
        return SubscriptionEventBinaryCacheHolder.INSTANCE;
    }

    private SubscriptionPollResponseCache() {
        PipeDataNodeResourceManager.memory();
        long initMemorySizeInBytes = PipeMemoryManager.getTotalNonFloatingMemorySizeInBytes() / 5L;
        PipeDataNodeResourceManager.memory();
        long maxMemorySizeInBytes = (long)((float)PipeMemoryManager.getTotalNonFloatingMemorySizeInBytes() * SubscriptionConfig.getInstance().getSubscriptionCacheMemoryUsagePercentage());
        PipeMemoryBlock allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(initMemorySizeInBytes);
        this.cache = Caffeine.newBuilder().maximumWeight(allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((message, buffer) -> buffer.capacity()).recordStats().build(CachedSubscriptionPollResponse::serialize);
        allocatedMemoryBlock.setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setShrinkCallback((oldMemory, newMemory) -> {
            this.cache.policy().eviction().ifPresent(eviction -> eviction.setMaximum(newMemory.longValue()));
            LOGGER.info("SubscriptionEventBinaryCache.allocatedMemoryBlock has shrunk from {} to {}.", oldMemory, newMemory);
        }).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, maxMemorySizeInBytes)).setExpandCallback((oldMemory, newMemory) -> {
            this.cache.policy().eviction().ifPresent(eviction -> eviction.setMaximum(newMemory.longValue()));
            LOGGER.info("SubscriptionEventBinaryCache.allocatedMemoryBlock has expanded from {} to {}.", oldMemory, newMemory);
        });
    }

    private static class SubscriptionEventBinaryCacheHolder {
        private static final SubscriptionPollResponseCache INSTANCE = new SubscriptionPollResponseCache();

        private SubscriptionEventBinaryCacheHolder() {
        }
    }
}

