/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.polaris.core.admin.model.AddGrantRequest;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.CreatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.RevokeGrantRequest;

public final class Serializers {
    private Serializers() {
    }

    public static void registerSerializers(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CreateCatalogRequest.class, (JsonDeserializer)new CreateCatalogRequestDeserializer());
        module.addDeserializer(CreatePrincipalRequest.class, (JsonDeserializer)new CreatePrincipalRequestDeserializer());
        module.addDeserializer(CreatePrincipalRoleRequest.class, (JsonDeserializer)new CreatePrincipalRoleRequestDeserializer());
        module.addDeserializer(GrantPrincipalRoleRequest.class, (JsonDeserializer)new GrantPrincipalRoleRequestDeserializer());
        module.addDeserializer(CreateCatalogRoleRequest.class, (JsonDeserializer)new CreateCatalogRoleRequestDeserializer());
        module.addDeserializer(GrantCatalogRoleRequest.class, (JsonDeserializer)new GrantCatalogRoleRequestDeserializer());
        module.addDeserializer(AddGrantRequest.class, (JsonDeserializer)new AddGrantRequestDeserializer());
        module.addDeserializer(RevokeGrantRequest.class, (JsonDeserializer)new RevokeGrantRequestDeserializer());
        mapper.registerModule((Module)module);
    }

    public static final class CreateCatalogRequestDeserializer
    extends JsonDeserializer<CreateCatalogRequest> {
        public CreateCatalogRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("catalog")) {
                return CreateCatalogRequest.builder().setCatalog((Catalog)ctxt.readTreeAsValue((JsonNode)treeNode.get("catalog"), Catalog.class)).build();
            }
            return CreateCatalogRequest.builder().setCatalog((Catalog)ctxt.readTreeAsValue((JsonNode)treeNode, Catalog.class)).build();
        }
    }

    public static final class CreatePrincipalRequestDeserializer
    extends JsonDeserializer<CreatePrincipalRequest> {
        public CreatePrincipalRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("principal")) {
                return CreatePrincipalRequest.builder().setPrincipal((Principal)ctxt.readTreeAsValue((JsonNode)treeNode.get("principal"), Principal.class)).setCredentialRotationRequired((Boolean)ctxt.readTreeAsValue((JsonNode)treeNode.get("credentialRotationRequired"), Boolean.class)).build();
            }
            return CreatePrincipalRequest.builder().setPrincipal((Principal)ctxt.readTreeAsValue((JsonNode)treeNode, Principal.class)).build();
        }
    }

    public static final class CreatePrincipalRoleRequestDeserializer
    extends JsonDeserializer<CreatePrincipalRoleRequest> {
        public CreatePrincipalRoleRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("principalRole")) {
                return CreatePrincipalRoleRequest.builder().setPrincipalRole((PrincipalRole)ctxt.readTreeAsValue((JsonNode)treeNode.get("principalRole"), PrincipalRole.class)).build();
            }
            return CreatePrincipalRoleRequest.builder().setPrincipalRole((PrincipalRole)ctxt.readTreeAsValue((JsonNode)treeNode, PrincipalRole.class)).build();
        }
    }

    public static final class GrantPrincipalRoleRequestDeserializer
    extends JsonDeserializer<GrantPrincipalRoleRequest> {
        public GrantPrincipalRoleRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("principalRole")) {
                return GrantPrincipalRoleRequest.builder().setPrincipalRole((PrincipalRole)ctxt.readTreeAsValue((JsonNode)treeNode.get("principalRole"), PrincipalRole.class)).build();
            }
            return GrantPrincipalRoleRequest.builder().setPrincipalRole((PrincipalRole)ctxt.readTreeAsValue((JsonNode)treeNode, PrincipalRole.class)).build();
        }
    }

    public static final class CreateCatalogRoleRequestDeserializer
    extends JsonDeserializer<CreateCatalogRoleRequest> {
        public CreateCatalogRoleRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("catalogRole")) {
                return CreateCatalogRoleRequest.builder().setCatalogRole((CatalogRole)ctxt.readTreeAsValue((JsonNode)treeNode.get("catalogRole"), CatalogRole.class)).build();
            }
            return CreateCatalogRoleRequest.builder().setCatalogRole((CatalogRole)ctxt.readTreeAsValue((JsonNode)treeNode, CatalogRole.class)).build();
        }
    }

    public static final class GrantCatalogRoleRequestDeserializer
    extends JsonDeserializer<GrantCatalogRoleRequest> {
        public GrantCatalogRoleRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("catalogRole")) {
                return GrantCatalogRoleRequest.builder().setCatalogRole((CatalogRole)ctxt.readTreeAsValue((JsonNode)treeNode.get("catalogRole"), CatalogRole.class)).build();
            }
            return GrantCatalogRoleRequest.builder().setCatalogRole((CatalogRole)ctxt.readTreeAsValue((JsonNode)treeNode, CatalogRole.class)).build();
        }
    }

    public static final class AddGrantRequestDeserializer
    extends JsonDeserializer<AddGrantRequest> {
        public AddGrantRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("grant")) {
                return AddGrantRequest.builder().setGrant((GrantResource)ctxt.readTreeAsValue((JsonNode)treeNode.get("grant"), GrantResource.class)).build();
            }
            return AddGrantRequest.builder().setGrant((GrantResource)ctxt.readTreeAsValue((JsonNode)treeNode, GrantResource.class)).build();
        }
    }

    public static final class RevokeGrantRequestDeserializer
    extends JsonDeserializer<RevokeGrantRequest> {
        public RevokeGrantRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode treeNode = p.readValueAsTree();
            if (treeNode.isObject() && ((ObjectNode)treeNode).has("grant")) {
                return RevokeGrantRequest.builder().setGrant((GrantResource)ctxt.readTreeAsValue((JsonNode)treeNode.get("grant"), GrantResource.class)).build();
            }
            return RevokeGrantRequest.builder().setGrant((GrantResource)ctxt.readTreeAsValue((JsonNode)treeNode, GrantResource.class)).build();
        }
    }
}

