/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.client;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.inbox.rpc.proto.InboxServiceGrpc;
import org.apache.bifromq.inbox.rpc.proto.SendReply;
import org.apache.bifromq.inbox.rpc.proto.SendRequest;
import org.apache.bifromq.inbox.util.InboxServiceUtil;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryRequest;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxDeliverPipeline
implements IDeliverer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxDeliverPipeline.class);
    private final IRPCClient.IRequestPipeline<SendRequest, SendReply> ppln;

    InboxDeliverPipeline(String delivererKey, IRPCClient rpcClient) {
        String tenantId = InboxServiceUtil.parseTenantId((String)delivererKey);
        this.ppln = rpcClient.createRequestPipeline(tenantId, null, delivererKey, Map.of("1", delivererKey), InboxServiceGrpc.getReceiveMethod());
    }

    public CompletableFuture<DeliveryReply> deliver(DeliveryRequest request) {
        long reqId = System.nanoTime();
        return ((CompletableFuture)this.ppln.invoke((Object)SendRequest.newBuilder().setReqId(reqId).setRequest(request).build()).thenApply(SendReply::getReply)).exceptionally(e -> {
            log.debug("Failed to deliver request: {}", (Object)request, e);
            return DeliveryReply.newBuilder().setCode(DeliveryReply.Code.ERROR).build();
        });
    }

    public void close() {
        this.ppln.close();
    }
}

