/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cluster;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterGroup;

public class ClientClusterGroupProjection {
    private static final short ATTRIBUTE = 1;
    private static final short SERVER_NODES = 2;
    private final ProjectionItem[] prjItems;

    private ClientClusterGroupProjection(ProjectionItem[] prjItems) {
        this.prjItems = prjItems;
    }

    public static ClientClusterGroupProjection read(BinaryRawReader reader) {
        int cnt = reader.readInt();
        ProjectionItem[] items = cnt == 0 ? null : new ProjectionItem[cnt];
        block4: for (int i = 0; i < cnt; ++i) {
            short code = reader.readShort();
            switch (code) {
                case 1: {
                    items[i] = new ForAttributeProjectionItem(reader);
                    continue block4;
                }
                case 2: {
                    items[i] = new ForServerNodesProjectionItem(reader);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown code: " + code);
                }
            }
        }
        return new ClientClusterGroupProjection(items);
    }

    public ClusterGroup apply(ClusterGroup clusterGrp) {
        if (this.prjItems != null) {
            for (ProjectionItem item : this.prjItems) {
                clusterGrp = item.apply(clusterGrp);
            }
        }
        return clusterGrp;
    }

    private static final class ForServerNodesProjectionItem
    implements ProjectionItem {
        private final Boolean isForSrvNodes;

        public ForServerNodesProjectionItem(BinaryRawReader reader) {
            this.isForSrvNodes = reader.readBoolean();
        }

        @Override
        public ClusterGroup apply(ClusterGroup clusterGrp) {
            return this.isForSrvNodes != false ? clusterGrp.forServers() : clusterGrp.forClients();
        }
    }

    private static final class ForAttributeProjectionItem
    implements ProjectionItem {
        private final String name;
        private final Object val;

        public ForAttributeProjectionItem(BinaryRawReader reader) {
            this.name = reader.readString();
            this.val = reader.readObject();
        }

        @Override
        public ClusterGroup apply(ClusterGroup clusterGrp) {
            return clusterGrp.forAttribute(this.name, this.val);
        }
    }

    private static interface ProjectionItem {
        public ClusterGroup apply(ClusterGroup var1);
    }
}

