/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestSharedInputBuffer {
    private static final Timeout TIMEOUT = Timeout.ofMinutes((long)1L);

    TestSharedInputBuffer() {
    }

    @Test
    void testBasis() throws Exception {
        Charset charset = StandardCharsets.US_ASCII;
        SharedInputBuffer inputBuffer = new SharedInputBuffer(10);
        inputBuffer.fill(charset.encode("1234567890"));
        Assertions.assertEquals((int)10, (int)inputBuffer.length());
        CapacityChannel capacityChannel = (CapacityChannel)Mockito.mock(CapacityChannel.class);
        inputBuffer.updateCapacity(capacityChannel);
        Mockito.verifyNoInteractions((Object[])new Object[]{capacityChannel});
        inputBuffer.fill(charset.encode("1234567890"));
        inputBuffer.fill(charset.encode("1234567890"));
        Assertions.assertEquals((int)30, (int)inputBuffer.length());
        Mockito.verifyNoInteractions((Object[])new Object[]{capacityChannel});
        byte[] tmp = new byte[20];
        int bytesRead1 = inputBuffer.read(tmp, 0, tmp.length);
        Assertions.assertEquals((int)20, (int)bytesRead1);
        Mockito.verifyNoInteractions((Object[])new Object[]{capacityChannel});
        inputBuffer.markEndStream();
        Assertions.assertEquals((int)49, (int)inputBuffer.read());
        Assertions.assertEquals((int)50, (int)inputBuffer.read());
        int bytesRead2 = inputBuffer.read(tmp, 0, tmp.length);
        Assertions.assertEquals((int)8, (int)bytesRead2);
        Mockito.verifyNoInteractions((Object[])new Object[]{capacityChannel});
        Assertions.assertEquals((int)-1, (int)inputBuffer.read(tmp, 0, tmp.length));
        Assertions.assertEquals((int)-1, (int)inputBuffer.read(tmp, 0, tmp.length));
        Assertions.assertEquals((int)-1, (int)inputBuffer.read());
        Assertions.assertEquals((int)-1, (int)inputBuffer.read());
    }

    @Test
    void testMultithreadingRead() throws Exception {
        SharedInputBuffer inputBuffer = new SharedInputBuffer(10);
        CapacityChannel capacityChannel = (CapacityChannel)Mockito.mock(CapacityChannel.class);
        inputBuffer.updateCapacity(capacityChannel);
        ((CapacityChannel)Mockito.verify((Object)capacityChannel)).update(10);
        Mockito.reset((Object[])new CapacityChannel[]{capacityChannel});
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Boolean> task1 = executorService.submit(() -> {
            Charset charset = StandardCharsets.US_ASCII;
            inputBuffer.fill(charset.encode("1234567890"));
            return Boolean.TRUE;
        });
        Future<Integer> task2 = executorService.submit(() -> {
            byte[] tmp = new byte[20];
            return inputBuffer.read(tmp, 0, tmp.length);
        });
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        Assertions.assertEquals((Integer)10, (Integer)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        ((CapacityChannel)Mockito.verify((Object)capacityChannel)).update(10);
    }

    @Test
    void testMultithreadingSingleRead() throws Exception {
        SharedInputBuffer inputBuffer = new SharedInputBuffer(10);
        CapacityChannel capacityChannel = (CapacityChannel)Mockito.mock(CapacityChannel.class);
        inputBuffer.updateCapacity(capacityChannel);
        ((CapacityChannel)Mockito.verify((Object)capacityChannel)).update(10);
        Mockito.reset((Object[])new CapacityChannel[]{capacityChannel});
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Boolean> task1 = executorService.submit(() -> {
            Charset charset = StandardCharsets.US_ASCII;
            inputBuffer.fill(charset.encode("a"));
            return Boolean.TRUE;
        });
        Future<Integer> task2 = executorService.submit(() -> ((SharedInputBuffer)inputBuffer).read());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        Assertions.assertEquals((Integer)97, (Integer)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        ((CapacityChannel)Mockito.verify((Object)capacityChannel)).update(1);
    }

    @Test
    void testMultithreadingReadStream() throws Exception {
        SharedInputBuffer inputBuffer = new SharedInputBuffer(10);
        CapacityChannel capacityChannel = (CapacityChannel)Mockito.mock(CapacityChannel.class);
        inputBuffer.updateCapacity(capacityChannel);
        ((CapacityChannel)Mockito.verify((Object)capacityChannel)).update(10);
        Mockito.reset((Object[])new CapacityChannel[]{capacityChannel});
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Boolean> task1 = executorService.submit(() -> {
            Charset charset = StandardCharsets.US_ASCII;
            Random rnd = new Random(System.currentTimeMillis());
            for (int i = 0; i < 5; ++i) {
                inputBuffer.fill(charset.encode("1234567890"));
                Thread.sleep(rnd.nextInt(250));
            }
            inputBuffer.markEndStream();
            return Boolean.TRUE;
        });
        Future<String> task2 = executorService.submit(() -> {
            int l;
            Charset charset = StandardCharsets.US_ASCII;
            StringBuilder buf = new StringBuilder();
            byte[] tmp = new byte[10];
            while ((l = inputBuffer.read(tmp, 0, tmp.length)) != -1) {
                buf.append(charset.decode(ByteBuffer.wrap(tmp, 0, l)));
            }
            return buf.toString();
        });
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        Assertions.assertEquals((Object)"12345678901234567890123456789012345678901234567890", (Object)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        ((CapacityChannel)Mockito.verify((Object)capacityChannel, (VerificationMode)Mockito.atLeast((int)1))).update(ArgumentMatchers.anyInt());
    }

    @Test
    void testMultithreadingReadStreamAbort() throws Exception {
        SharedInputBuffer inputBuffer = new SharedInputBuffer(10);
        CapacityChannel capacityChannel = (CapacityChannel)Mockito.mock(CapacityChannel.class);
        inputBuffer.updateCapacity(capacityChannel);
        ((CapacityChannel)Mockito.verify((Object)capacityChannel)).update(10);
        Mockito.reset((Object[])new CapacityChannel[]{capacityChannel});
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Boolean> task1 = executorService.submit(() -> {
            Thread.sleep(1000L);
            inputBuffer.abort();
            return Boolean.TRUE;
        });
        Future<Integer> task2 = executorService.submit(() -> ((SharedInputBuffer)inputBuffer).read());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)task1.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit()));
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Integer cfr_ignored_0 = (Integer)task2.get(TIMEOUT.getDuration(), TIMEOUT.getTimeUnit());
        });
        Assertions.assertInstanceOf(InterruptedIOException.class, (Object)ex.getCause());
        ((CapacityChannel)Mockito.verify((Object)capacityChannel, (VerificationMode)Mockito.never())).update(10);
    }
}

