/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.ArrayList;
import java.util.Iterator;

public class Collection
implements Constants {
    private String type;
    private ArrayList<Element> elements = new ArrayList();
    private Schema schema;

    public Collection(Schema schema, String type) {
        this.schema = schema;
        this.type = type;
    }

    public Iterator<Element> getElements() {
        return this.elements.iterator();
    }

    public String toString() {
        return "Collection{type=" + this.type + "elements=" + this.elements + '}';
    }

    void read(WsdlParser parser) throws WsdlParseException {
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("element".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    Element element = new Element(this.schema);
                    element.read(parser);
                    this.elements.add(element);
                } else if (!("sequence".equals(name) || "choice".equals(name) || "all".equals(name) || "any".equals(name))) {
                    throw new WsdlParseException("Unexpected element '" + name + "' at: " + parser.getPositionDescription());
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if (this.type.equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    return;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'complexType'");
            }
            eventType = parser.next();
        }
    }
}

