/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.bulk;

import com.sforce.bulk.StreamException;
import com.sforce.ws.ConnectorConfig;
import java.io.PrintStream;

public class StreamHandler {
    private static final String BULK_TAG = "BULK-STREAM:";
    private final ConnectorConfig config = new ConnectorConfig();
    private boolean shutdown = false;
    private int errorCount;

    public ConnectorConfig getConfig() {
        return this.config;
    }

    public PrintStream getLogStream() {
        return System.out;
    }

    public void info(String message) {
        this.getLogStream().println("BULK-STREAM:INFO:" + message);
    }

    public void error(String message, Throwable e) throws StreamException {
        ++this.errorCount;
        this.getLogStream().println("BULK-STREAM:ERROR:" + message);
        e.printStackTrace(this.getLogStream());
        if (this.errorCount > this.getMaxErrorCount()) {
            String str = "Tried more than " + this.getMaxErrorCount() + "... gaving up ...";
            this.info(str);
            this.shutdown = true;
        } else {
            long waitTime = this.getWaitTime();
            this.info("Error count " + this.errorCount + ". Trying again after " + waitTime);
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e1) {
                this.error("Failed to sleep", e1);
            }
        }
    }

    public long getWaitTime() {
        return (long)(Math.pow(2.0, this.errorCount) * 1000.0);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean shouldContinue() {
        return !this.shutdown;
    }

    public int getMaxErrorCount() {
        return 10;
    }

    public int getMaxRecordsInBatch() {
        return 5000;
    }

    public long getMaxWaitTime() {
        return 600000L;
    }
}

