/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cratedbbulkloader.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.HttpBulkImportResponse;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.exceptions.CrateDBHopException;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.exceptions.UnauthorizedCrateDBAccessException;

public class BulkImportClient {
    private final String httpEndpoint;
    private final String authorizationHeader;

    public BulkImportClient(String httpEndpoint, String username, String password) {
        this.httpEndpoint = httpEndpoint;
        this.authorizationHeader = this.header(username, password);
    }

    private String header(String username, String password) {
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        return "Basic " + encodedAuth;
    }

    public HttpBulkImportResponse batchInsert(String schema, String table, String[] columns, List<Object[]> args) throws HopException, CrateDBHopException, IOException {
        HttpResponse<String> httpResponse;
        ObjectMapper mapper = new ObjectMapper();
        BulkImportRequest body = new BulkImportRequest(schema + "." + table, List.of(columns), args);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.httpEndpoint)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", this.authorizationHeader).POST(HttpRequest.BodyPublishers.ofString(mapper.writeValueAsString((Object)body), StandardCharsets.UTF_8)).build();
        HttpClient client = HttpClient.newHttpClient();
        try {
            httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            throw new HopException("Couldn't process the request", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HopException("Couldn't process the request", (Throwable)e);
        }
        switch (httpResponse.statusCode()) {
            case 200: {
                return HttpBulkImportResponse.fromHttpResponse(httpResponse);
            }
            case 401: {
                throw new UnauthorizedCrateDBAccessException(httpResponse.body());
            }
        }
        throw new CrateDBHopException(httpResponse.statusCode(), httpResponse.body());
    }

    private static class BulkImportRequest {
        private String stmt;
        private List<Object[]> bulkArgs;

        public BulkImportRequest(String table, List<String> columns, List<Object[]> bulkArgs) {
            String argsPlaceholders = columns.stream().map(c -> "?").collect(Collectors.joining(", "));
            this.stmt = "INSERT INTO " + table + " (" + String.join((CharSequence)", ", columns) + ") VALUES (" + argsPlaceholders + ")";
            this.bulkArgs = bulkArgs;
        }

        public String getStmt() {
            return this.stmt;
        }

        @JsonProperty(value="bulk_args")
        public List<Object[]> getBulkArgs() {
            return this.bulkArgs;
        }
    }
}

