/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.append;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.append.AppendMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AppendDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = AppendDialog.class;
    private CCombo wHeadHop;
    private CCombo wTailHop;
    private final AppendMeta input;

    public AppendDialog(Shell parent, IVariables variables, AppendMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AppendDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AppendDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        String[] previousTransforms = this.pipelineMeta.getPrevTransformNames(this.transformName);
        Label wlHeadHop = new Label((Composite)this.shell, 131072);
        wlHeadHop.setText(BaseMessages.getString(PKG, (String)"AppendDialog.HeadHop.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHeadHop);
        FormData fdlHeadHop = new FormData();
        fdlHeadHop.left = new FormAttachment(0, 0);
        fdlHeadHop.right = new FormAttachment(middle, -margin);
        fdlHeadHop.top = new FormAttachment((Control)this.wTransformName, margin);
        wlHeadHop.setLayoutData((Object)fdlHeadHop);
        this.wHeadHop = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wHeadHop);
        if (previousTransforms != null) {
            this.wHeadHop.setItems(previousTransforms);
        }
        this.wHeadHop.addModifyListener(lsMod);
        FormData fdHeadHop = new FormData();
        fdHeadHop.left = new FormAttachment(middle, 0);
        fdHeadHop.top = new FormAttachment((Control)this.wTransformName, margin);
        fdHeadHop.right = new FormAttachment(100, 0);
        this.wHeadHop.setLayoutData((Object)fdHeadHop);
        Label wlTailHop = new Label((Composite)this.shell, 131072);
        wlTailHop.setText(BaseMessages.getString(PKG, (String)"AppendDialog.TailHop.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTailHop);
        FormData fdlTailHop = new FormData();
        fdlTailHop.left = new FormAttachment(0, 0);
        fdlTailHop.right = new FormAttachment(middle, -margin);
        fdlTailHop.top = new FormAttachment((Control)this.wHeadHop, margin);
        wlTailHop.setLayoutData((Object)fdlTailHop);
        this.wTailHop = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTailHop);
        if (previousTransforms != null) {
            this.wTailHop.setItems(previousTransforms);
        }
        this.wTailHop.addModifyListener(lsMod);
        FormData fdTailHop = new FormData();
        fdTailHop.top = new FormAttachment((Control)this.wHeadHop, margin);
        fdTailHop.left = new FormAttachment(middle, 0);
        fdTailHop.right = new FormAttachment(100, 0);
        this.wTailHop.setLayoutData((Object)fdTailHop);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wTailHop);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wHeadHop.setText(Const.NVL((String)this.input.getHeadTransformName(), (String)""));
        this.wTailHop.setText(Const.NVL((String)this.input.getTailTransformName(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setHeadTransformName(this.wHeadHop.getText());
        this.input.setTailTransformName(this.wTailHop.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }
}

