/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.BlockedOnParentShardException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibLeaseCoordinator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.ShutdownInput;
import com.amazonaws.services.kinesis.leases.LeasePendingDeletion;
import com.amazonaws.services.kinesis.leases.exceptions.CustomerApplicationException;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.LeaseCleanupManager;
import com.amazonaws.services.kinesis.leases.impl.UpdateField;
import com.amazonaws.services.kinesis.model.ChildShard;
import com.amazonaws.util.CollectionUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShutdownTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(ShutdownTask.class);
    @VisibleForTesting
    static final int RETRY_RANDOM_MAX_RANGE = 50;
    private final ShardInfo shardInfo;
    private final IRecordProcessor recordProcessor;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final ShutdownReason reason;
    private final IKinesisProxy kinesisProxy;
    private final KinesisClientLibLeaseCoordinator leaseCoordinator;
    private final InitialPositionInStreamExtended initialPositionInStream;
    private final boolean cleanupLeasesOfCompletedShards;
    private final boolean ignoreUnexpectedChildShards;
    private final TaskType taskType = TaskType.SHUTDOWN;
    private final long backoffTimeMillis;
    private final GetRecordsCache getRecordsCache;
    private final ShardSyncer shardSyncer;
    private final ShardSyncStrategy shardSyncStrategy;
    private final List<ChildShard> childShards;
    private final LeaseCleanupManager leaseCleanupManager;

    ShutdownTask(ShardInfo shardInfo, IRecordProcessor recordProcessor, RecordProcessorCheckpointer recordProcessorCheckpointer, ShutdownReason reason, IKinesisProxy kinesisProxy, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, KinesisClientLibLeaseCoordinator leaseCoordinator, long backoffTimeMillis, GetRecordsCache getRecordsCache, ShardSyncer shardSyncer, ShardSyncStrategy shardSyncStrategy, List<ChildShard> childShards, LeaseCleanupManager leaseCleanupManager) {
        this.shardInfo = shardInfo;
        this.recordProcessor = recordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.reason = reason;
        this.kinesisProxy = kinesisProxy;
        this.initialPositionInStream = initialPositionInStream;
        this.cleanupLeasesOfCompletedShards = cleanupLeasesOfCompletedShards;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.leaseCoordinator = leaseCoordinator;
        this.backoffTimeMillis = backoffTimeMillis;
        this.getRecordsCache = getRecordsCache;
        this.shardSyncer = shardSyncer;
        this.shardSyncStrategy = shardSyncStrategy;
        this.childShards = childShards;
        this.leaseCleanupManager = leaseCleanupManager;
    }

    @Override
    public TaskResult call() {
        LOG.info((Object)("Invoking shutdown() for shard " + this.shardInfo.getShardId() + ", concurrencyToken: " + this.shardInfo.getConcurrencyToken() + ", original Shutdown reason: " + (Object)((Object)this.reason) + ". childShards:" + this.childShards));
        try {
            KinesisClientLease currentShardLease = (KinesisClientLease)this.leaseCoordinator.getCurrentlyHeldLease(this.shardInfo.getShardId());
            Runnable leaseLostAction = () -> this.takeLeaseLostAction();
            if (this.reason == ShutdownReason.TERMINATE) {
                try {
                    this.takeShardEndAction(currentShardLease);
                }
                catch (InvalidStateException e) {
                    LOG.warn((Object)("Lease " + this.shardInfo.getShardId() + ": Invalid state encountered while shutting down shardConsumer with TERMINATE reason. Dropping the lease and shutting down shardConsumer using ZOMBIE reason. "), (Throwable)e);
                    this.dropLease(currentShardLease);
                    this.throwOnApplicationException(leaseLostAction);
                }
            } else {
                this.throwOnApplicationException(leaseLostAction);
            }
            LOG.debug((Object)"Shutting down retrieval strategy.");
            this.getRecordsCache.shutdown();
            LOG.debug((Object)("Record processor completed shutdown() for shard " + this.shardInfo.getShardId()));
            return new TaskResult(null);
        }
        catch (Exception e) {
            if (e instanceof CustomerApplicationException) {
                LOG.error((Object)("Shard " + this.shardInfo.getShardId() + ": Application exception: "), (Throwable)e);
            } else {
                LOG.error((Object)("Shard " + this.shardInfo.getShardId() + ": Caught exception: "), (Throwable)e);
            }
            Exception exception = e;
            try {
                Thread.sleep(this.backoffTimeMillis);
            }
            catch (InterruptedException ie) {
                LOG.debug((Object)"Interrupted sleep", (Throwable)ie);
            }
            return new TaskResult(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeShardEndAction(KinesisClientLease currentShardLease) throws InvalidStateException, DependencyException, ProvisionedThroughputException, CustomerApplicationException {
        if (currentShardLease == null) {
            throw new InvalidStateException("Shard " + this.shardInfo.getShardId() + ": Lease not owned by the current worker. Leaving ShardEnd handling to new owner.");
        }
        if (!CollectionUtils.isNullOrEmpty(this.childShards)) {
            this.createLeasesForChildShardsIfNotExist();
            this.updateCurrentLeaseWithChildShards(currentShardLease);
        } else {
            LOG.warn((Object)("Shard " + this.shardInfo.getShardId() + ": Shutting down consumer with SHARD_END reason without creating leases for child shards."));
        }
        LeasePendingDeletion leasePendingDeletion = new LeasePendingDeletion(currentShardLease, this.shardInfo);
        if (!this.leaseCleanupManager.isEnqueuedForDeletion(leasePendingDeletion)) {
            boolean isSuccess = false;
            try {
                isSuccess = this.attemptShardEndCheckpointing();
            }
            finally {
                if (isSuccess || CollectionUtils.isNullOrEmpty(this.childShards)) {
                    this.leaseCleanupManager.enqueueForDeletion(leasePendingDeletion);
                }
            }
        }
    }

    private void takeLeaseLostAction() {
        ShutdownInput leaseLostShutdownInput = new ShutdownInput().withShutdownReason(ShutdownReason.ZOMBIE).withCheckpointer(this.recordProcessorCheckpointer);
        this.recordProcessor.shutdown(leaseLostShutdownInput);
    }

    private boolean attemptShardEndCheckpointing() throws DependencyException, ProvisionedThroughputException, InvalidStateException, CustomerApplicationException {
        KinesisClientLease leaseFromDdb = Optional.ofNullable(this.leaseCoordinator.getLeaseManager().getLease(this.shardInfo.getShardId())).orElseThrow(() -> new InvalidStateException("Lease for shard " + this.shardInfo.getShardId() + " does not exist."));
        if (!leaseFromDdb.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END)) {
            this.throwOnApplicationException(() -> this.applicationCheckpointAndVerification());
        }
        return true;
    }

    private void applicationCheckpointAndVerification() {
        this.recordProcessorCheckpointer.setSequenceNumberAtShardEnd(this.recordProcessorCheckpointer.getLargestPermittedCheckpointValue());
        this.recordProcessorCheckpointer.setLargestPermittedCheckpointValue(ExtendedSequenceNumber.SHARD_END);
        ShutdownInput shardEndShutdownInput = new ShutdownInput().withShutdownReason(ShutdownReason.TERMINATE).withCheckpointer(this.recordProcessorCheckpointer);
        this.recordProcessor.shutdown(shardEndShutdownInput);
        boolean successfullyCheckpointedShardEnd = false;
        KinesisClientLease leaseFromDdb = null;
        try {
            leaseFromDdb = this.leaseCoordinator.getLeaseManager().getLease(this.shardInfo.getShardId());
        }
        catch (Exception e) {
            LOG.error((Object)("Shard " + this.shardInfo.getShardId() + " : Unable to get lease entry for shard to verify shard end checkpointing."), (Throwable)e);
        }
        if (leaseFromDdb != null && leaseFromDdb.getCheckpoint() != null) {
            successfullyCheckpointedShardEnd = leaseFromDdb.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END);
            ExtendedSequenceNumber lastCheckpointValue = this.recordProcessorCheckpointer.getLastCheckpointValue();
            if (!leaseFromDdb.getCheckpoint().equals(lastCheckpointValue)) {
                LOG.error((Object)("Shard " + this.shardInfo.getShardId() + " : Checkpoint information mismatch between authoritative source and local cache. This does not affect the application flow, but cut a ticket to Kinesis when you see this. Authoritative entry : " + leaseFromDdb.getCheckpoint() + " Cache entry : " + lastCheckpointValue));
            }
        } else {
            LOG.error((Object)("Shard " + this.shardInfo.getShardId() + " : No lease checkpoint entry for shard to verify shard end checkpointing. Lease Entry : " + leaseFromDdb));
        }
        if (!successfullyCheckpointedShardEnd) {
            throw new IllegalArgumentException("Application didn't checkpoint at end of shard " + this.shardInfo.getShardId() + ". Application must checkpoint upon shutdown. See IRecordProcessor.shutdown javadocs for more information.");
        }
    }

    private void throwOnApplicationException(Runnable action) throws CustomerApplicationException {
        try {
            action.run();
        }
        catch (Exception e) {
            throw new CustomerApplicationException("Customer application throws exception for shard " + this.shardInfo.getShardId(), e);
        }
    }

    private void createLeasesForChildShardsIfNotExist() throws InvalidStateException, DependencyException, ProvisionedThroughputException {
        if (!CollectionUtils.isNullOrEmpty(this.childShards) && this.childShards.size() == 1) {
            boolean isValidLeaseTableState;
            ChildShard childShard = this.childShards.get(0);
            List parentLeaseKeys = childShard.getParentShards();
            if (parentLeaseKeys.size() != 2) {
                throw new InvalidStateException("Shard " + this.shardInfo.getShardId() + "'s only child shard " + childShard + " does not contain other parent information.");
            }
            boolean bl = isValidLeaseTableState = Objects.isNull(this.leaseCoordinator.getLeaseManager().getLease((String)parentLeaseKeys.get(0))) == Objects.isNull(this.leaseCoordinator.getLeaseManager().getLease((String)parentLeaseKeys.get(1)));
            if (!isValidLeaseTableState) {
                if (!this.isOneInNProbability(50)) {
                    throw new BlockedOnParentShardException("Shard " + this.shardInfo.getShardId() + "'s only child shard " + childShard + " has partial parent information in lease table. Hence deferring lease creation of child shard.");
                }
                throw new InvalidStateException("Shard " + this.shardInfo.getShardId() + "'s only child shard " + childShard + " has partial parent information in lease table.");
            }
        }
        for (ChildShard childShard : this.childShards) {
            String leaseKey = childShard.getShardId();
            if (this.leaseCoordinator.getLeaseManager().getLease(leaseKey) != null) continue;
            KinesisClientLease leaseToCreate = KinesisShardSyncer.newKCLLeaseForChildShard(childShard);
            this.leaseCoordinator.getLeaseManager().createLeaseIfNotExists(leaseToCreate);
            LOG.info((Object)("Shard " + this.shardInfo.getShardId() + " : Created child shard lease: " + leaseToCreate.getLeaseKey()));
        }
    }

    @VisibleForTesting
    boolean isOneInNProbability(int n) {
        Random r = new Random();
        return 1 == r.nextInt(n - 1 + 1) + 1;
    }

    private void updateCurrentLeaseWithChildShards(KinesisClientLease currentLease) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        Set<String> childShardIds = this.childShards.stream().map(ChildShard::getShardId).collect(Collectors.toSet());
        currentLease.setChildShardIds(childShardIds);
        this.leaseCoordinator.getLeaseManager().updateLeaseWithMetaInfo(currentLease, UpdateField.CHILD_SHARDS);
        LOG.info((Object)("Shard " + this.shardInfo.getShardId() + ": Updated current lease with child shard information: " + currentLease.getLeaseKey()));
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @VisibleForTesting
    ShutdownReason getReason() {
        return this.reason;
    }

    private void dropLease(KinesisClientLease currentShardLease) {
        if (currentShardLease == null) {
            LOG.warn((Object)("Shard " + this.shardInfo.getShardId() + ": Unable to find the lease for shard. Will shutdown the shardConsumer directly."));
            return;
        }
        this.leaseCoordinator.dropLease(currentShardLease);
        LOG.warn((Object)("Dropped lease for shutting down ShardConsumer: " + currentShardLease.getLeaseKey()));
    }
}

