/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.gaxx.retrying;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.gaxx.retrying.AttemptCallable;
import com.google.common.base.Preconditions;

@InternalApi
public class RetryingCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiCallContext callContextPrototype;
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RetryingExecutorWithContext<ResponseT> executor;

    public RetryingCallable(ApiCallContext callContextPrototype, UnaryCallable<RequestT, ResponseT> callable, RetryingExecutorWithContext<ResponseT> executor) {
        this.callContextPrototype = (ApiCallContext)Preconditions.checkNotNull((Object)callContextPrototype);
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.executor = (RetryingExecutorWithContext)Preconditions.checkNotNull(executor);
    }

    public RetryingFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        ApiCallContext context = this.callContextPrototype.nullToSelf(inputContext);
        AttemptCallable<RequestT, ResponseT> retryCallable = new AttemptCallable<RequestT, ResponseT>(this.callable, request, context);
        RetryingFuture retryingFuture = this.executor.createFuture(retryCallable, (RetryingContext)inputContext);
        retryCallable.setExternalFuture(retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

