/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_Parse;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_ParseAll;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_ParseFiles;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_Read;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_ReadAll;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_ReadFiles;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_Sink;
import org.apache.beam.sdk.extensions.avro.io.AutoValue_AvroIO_TypedWrite;
import org.apache.beam.sdk.extensions.avro.io.AvroDatumFactory;
import org.apache.beam.sdk.extensions.avro.io.AvroSink;
import org.apache.beam.sdk.extensions.avro.io.AvroSource;
import org.apache.beam.sdk.extensions.avro.io.ConstantAvroDestination;
import org.apache.beam.sdk.extensions.avro.io.DynamicAvroDestinations;
import org.apache.beam.sdk.extensions.avro.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class AvroIO {
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BUNDLE_SIZE_BYTES = 0x4000000L;

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
        return new AutoValue_AvroIO_Read.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.DISALLOW)).setRecordClass(recordClass).setSchema(ReflectData.get().getSchema(recordClass)).setInferBeamSchema(false).setHintMatchesManyFiles(false).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ReadFiles<T> readFiles(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
        return new AutoValue_AvroIO_ReadFiles.Builder<T>().setRecordClass(recordClass).setSchema(ReflectData.get().getSchema(recordClass)).setInferBeamSchema(false).setDesiredBundleSizeBytes(0x4000000L).setUsesReshuffle(true).setFileExceptionHandler(new ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler()).build();
    }

    @Deprecated
    public static <T> @UnknownKeyFor @NonNull @Initialized ReadAll<T> readAll(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
        return new AutoValue_AvroIO_ReadAll.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.ALLOW_IF_WILDCARD)).setRecordClass(recordClass).setSchema(ReflectData.get().getSchema(recordClass)).setInferBeamSchema(false).setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized GenericRecord> readGenericRecords(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new AutoValue_AvroIO_Read.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.DISALLOW)).setRecordClass(GenericRecord.class).setSchema(schema).setInferBeamSchema(false).setHintMatchesManyFiles(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadFiles<@UnknownKeyFor @NonNull @Initialized GenericRecord> readFilesGenericRecords(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new AutoValue_AvroIO_ReadFiles.Builder<GenericRecord>().setRecordClass(GenericRecord.class).setSchema(schema).setInferBeamSchema(false).setDesiredBundleSizeBytes(0x4000000L).setUsesReshuffle(true).setFileExceptionHandler(new ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler()).build();
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized ReadAll<@UnknownKeyFor @NonNull @Initialized GenericRecord> readAllGenericRecords(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new AutoValue_AvroIO_ReadAll.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.ALLOW_IF_WILDCARD)).setRecordClass(GenericRecord.class).setSchema(schema).setInferBeamSchema(false).setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized GenericRecord> readGenericRecords(@UnknownKeyFor @NonNull @Initialized String schema) {
        return AvroIO.readGenericRecords(new Schema.Parser().parse(schema));
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadFiles<@UnknownKeyFor @NonNull @Initialized GenericRecord> readFilesGenericRecords(@UnknownKeyFor @NonNull @Initialized String schema) {
        return AvroIO.readFilesGenericRecords(new Schema.Parser().parse(schema));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized ReadAll<@UnknownKeyFor @NonNull @Initialized GenericRecord> readAllGenericRecords(@UnknownKeyFor @NonNull @Initialized String schema) {
        return AvroIO.readAllGenericRecords(new Schema.Parser().parse(schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Parse<T> parseGenericRecords(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn) {
        return new AutoValue_AvroIO_Parse.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.DISALLOW)).setParseFn(parseFn).setHintMatchesManyFiles(false).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ParseFiles<T> parseFilesGenericRecords(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn) {
        return new AutoValue_AvroIO_ParseFiles.Builder<T>().setParseFn(parseFn).setDesiredBundleSizeBytes(0x4000000L).setUsesReshuffle(true).setFileExceptionHandler(new ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler()).build();
    }

    @Deprecated
    public static <T> @UnknownKeyFor @NonNull @Initialized ParseAll<T> parseAllGenericRecords(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn) {
        return new AutoValue_AvroIO_ParseAll.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create((EmptyMatchTreatment)EmptyMatchTreatment.ALLOW_IF_WILDCARD)).setParseFn(parseFn).setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
        return new Write(AvroIO.defaultWriteBuilder().setGenericRecords(false).setSchema(ReflectData.get().getSchema(recordClass)).build());
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized GenericRecord> writeGenericRecords(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new Write<GenericRecord>(AvroIO.defaultWriteBuilder().setGenericRecords(true).setSchema(schema).build());
    }

    @Deprecated
    public static <UserT> @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, @UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized Object> writeCustomType() {
        return AvroIO.defaultWriteBuilder().setRecordClass(Object.class).build();
    }

    public static <UserT, OutputT> @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, @UnknownKeyFor @Nullable @Initialized Void, OutputT> writeCustomType(@UnknownKeyFor @NonNull @Initialized Class<OutputT> recordClass) {
        return AvroIO.defaultWriteBuilder().setRecordClass(recordClass).build();
    }

    public static <UserT> @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, @UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized GenericRecord> writeCustomTypeToGenericRecords() {
        return AvroIO.defaultWriteBuilder().setRecordClass(GenericRecord.class).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized GenericRecord> writeGenericRecords(@UnknownKeyFor @NonNull @Initialized String schema) {
        return AvroIO.writeGenericRecords(new Schema.Parser().parse(schema));
    }

    private static <UserT, OutputT> @UnknownKeyFor @NonNull @Initialized TypedWrite.Builder<UserT, @UnknownKeyFor @Nullable @Initialized Void, OutputT> defaultWriteBuilder() {
        return new AutoValue_AvroIO_TypedWrite.Builder().setFilenameSuffix(null).setShardTemplate(null).setNumShards(0).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).setMetadata((ImmutableMap<String, Object>)ImmutableMap.of()).setWindowedWrites(false).setNoSpilling(false).setSyncInterval(64000);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> setBeamSchema(@UnknownKeyFor @NonNull @Initialized PCollection<T> pc, @UnknownKeyFor @NonNull @Initialized Class<T> clazz, @Nullable @UnknownKeyFor @Initialized Schema schema) {
        return pc.setCoder(AvroUtils.schemaCoder(clazz, schema));
    }

    public static <UserT, OutputT> @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, @UnknownKeyFor @Nullable @Initialized Void, OutputT> constantDestinations(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata, @UnknownKeyFor @NonNull @Initialized CodecFactory codec, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
        return AvroIO.constantDestinations(filenamePolicy, schema, metadata, codec, formatFunction, null);
    }

    public static <UserT, OutputT> @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, @UnknownKeyFor @Nullable @Initialized Void, OutputT> constantDestinations(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata, @UnknownKeyFor @NonNull @Initialized CodecFactory codec, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction, @Nullable @UnknownKeyFor @Initialized AvroSink.DatumWriterFactory<OutputT> datumWriterFactory) {
        return new ConstantAvroDestination<UserT, OutputT>(filenamePolicy, schema, metadata, codec, formatFunction, datumWriterFactory);
    }

    public static <ElementT> @UnknownKeyFor @NonNull @Initialized Sink<ElementT> sink(@UnknownKeyFor @NonNull @Initialized Class<ElementT> clazz) {
        return new AutoValue_AvroIO_Sink.Builder().setJsonSchema(ReflectData.get().getSchema(clazz).toString()).setMetadata((Map<String, Object>)ImmutableMap.of()).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).setDatumWriterFactory(AvroDatumFactory.of(clazz)).build();
    }

    public static <ElementT extends IndexedRecord> @UnknownKeyFor @NonNull @Initialized Sink<ElementT> sink(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return AvroIO.sink(schema.toString());
    }

    public static <ElementT extends IndexedRecord> @UnknownKeyFor @NonNull @Initialized Sink<ElementT> sink(@UnknownKeyFor @NonNull @Initialized String jsonSchema) {
        return new AutoValue_AvroIO_Sink.Builder().setJsonSchema(jsonSchema).setMetadata((Map<String, Object>)ImmutableMap.of()).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).build();
    }

    @Deprecated
    public static <ElementT> @UnknownKeyFor @NonNull @Initialized Sink<ElementT> sinkViaGenericRecords(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized RecordFormatter<ElementT> formatter) {
        return new AutoValue_AvroIO_Sink.Builder<ElementT>().setRecordFormatter(formatter).setJsonSchema(schema.toString()).setMetadata((Map<String, Object>)ImmutableMap.of()).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).build();
    }

    private AvroIO() {
    }

    @AutoValue
    public static abstract class Sink<@UnknownKeyFor ElementT>
    implements FileIO.Sink<ElementT> {
        private transient @Nullable @UnknownKeyFor @Initialized Schema schema;
        private transient @Nullable @UnknownKeyFor @Initialized DataFileWriter<ElementT> writer;

        @Deprecated
        abstract @Nullable @UnknownKeyFor @Initialized RecordFormatter<ElementT> getRecordFormatter();

        abstract @Nullable @UnknownKeyFor @Initialized String getJsonSchema();

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getMetadata();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableAvroCodecFactory getCodec();

        abstract @Nullable @UnknownKeyFor @Initialized AvroSink.DatumWriterFactory<ElementT> getDatumWriterFactory();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ElementT> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Sink<ElementT> withMetadata(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata) {
            return this.toBuilder().setMetadata(metadata).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Sink<ElementT> withCodec(@UnknownKeyFor @NonNull @Initialized CodecFactory codec) {
            return this.toBuilder().setCodec(new SerializableAvroCodecFactory(codec)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Sink<ElementT> withDatumWriterFactory(@UnknownKeyFor @NonNull @Initialized AvroSink.DatumWriterFactory<ElementT> datumWriterFactory) {
            return this.toBuilder().setDatumWriterFactory(datumWriterFactory).build();
        }

        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.schema = new Schema.Parser().parse(this.getJsonSchema());
            Object datumWriter = this.getRecordFormatter() != null ? new FormattedDatumWriter(this.schema, this.getRecordFormatter()) : (this.getDatumWriterFactory() != null ? this.getDatumWriterFactory().apply(this.schema) : new ReflectDatumWriter(this.schema));
            this.writer = new DataFileWriter((DatumWriter)datumWriter);
            this.writer.setCodec(this.getCodec().getCodec());
            for (Map.Entry<String, Object> entry : this.getMetadata().entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String) {
                    this.writer.setMeta(entry.getKey(), (String)v);
                    continue;
                }
                if (v instanceof Long) {
                    this.writer.setMeta(entry.getKey(), ((Long)v).longValue());
                    continue;
                }
                if (v instanceof byte[]) {
                    this.writer.setMeta(entry.getKey(), (byte[])v);
                    continue;
                }
                throw new IllegalStateException("Metadata value type must be one of String, Long, or byte[]. Found " + v.getClass().getSimpleName());
            }
            this.writer.create(this.schema, Channels.newOutputStream(channel));
        }

        public void write(ElementT element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer.append(element);
        }

        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer.flush();
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor ElementT> {
            Builder() {
            }

            @Deprecated
            abstract @UnknownKeyFor @NonNull @Initialized Builder<ElementT> setRecordFormatter(@UnknownKeyFor @NonNull @Initialized RecordFormatter<ElementT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<ElementT> setJsonSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<ElementT> setMetadata(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<ElementT> setCodec(@UnknownKeyFor @NonNull @Initialized SerializableAvroCodecFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<ElementT> setDatumWriterFactory(@UnknownKeyFor @NonNull @Initialized AvroSink.DatumWriterFactory<ElementT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Sink<ElementT> build();
        }
    }

    private static class FormattedDatumWriter<@UnknownKeyFor ElementT>
    implements DatumWriter<ElementT> {
        private @UnknownKeyFor @NonNull @Initialized Schema root;
        private @UnknownKeyFor @NonNull @Initialized RecordFormatter<ElementT> formatter;
        private @UnknownKeyFor @NonNull @Initialized GenericDatumWriter<@UnknownKeyFor @NonNull @Initialized GenericRecord> writer;

        public FormattedDatumWriter(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized RecordFormatter<ElementT> formatter) {
            this.formatter = formatter;
            this.writer = new GenericDatumWriter(schema);
            this.setSchema(schema);
        }

        public void setSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.root = schema;
        }

        public void write(ElementT datum, @UnknownKeyFor @NonNull @Initialized Encoder out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.writer.write((Object)this.formatter.formatRecord(datum, this.root), out);
        }
    }

    @Deprecated
    public static interface RecordFormatter<@UnknownKeyFor ElementT>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized GenericRecord formatRecord(ElementT var1, @UnknownKeyFor @NonNull @Initialized Schema var2);
    }

    public static class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        @VisibleForTesting
        final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypedWrite<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> inner;

        Write(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypedWrite<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> inner) {
            this.inner = inner;
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized String outputPrefix) {
            return new Write<T>(this.inner.to(FileBasedSink.convertToFileResourceIfPossible((String)outputPrefix)).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized ResourceId outputPrefix) {
            return new Write<T>(this.inner.to(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> outputPrefix) {
            return new Write<T>(this.inner.to(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> toResource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> outputPrefix) {
            return new Write<T>(this.inner.toResource(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy) {
            return new Write<T>(this.inner.to(filenamePolicy).withFormatFunction(SerializableFunctions.identity()));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write<T> to(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> dynamicDestinations) {
            return new Write<T>(this.inner.to(dynamicDestinations).withFormatFunction(null));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSyncInterval(@UnknownKeyFor @NonNull @Initialized int syncInterval) {
            return new Write<T>(this.inner.withSyncInterval(syncInterval));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return new Write<T>(this.inner.withSchema(schema));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectory) {
            return new Write<T>(this.inner.withTempDirectory(tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory) {
            return new Write<T>(this.inner.withTempDirectory(tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withShardNameTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return new Write<T>(this.inner.withShardNameTemplate(shardTemplate));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSuffix(@UnknownKeyFor @NonNull @Initialized String filenameSuffix) {
            return new Write<T>(this.inner.withSuffix(filenameSuffix));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
            return new Write<T>(this.inner.withNumShards(numShards));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withoutSharding() {
            return new Write<T>(this.inner.withoutSharding());
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWindowedWrites() {
            return new Write<T>(this.inner.withWindowedWrites());
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCodec(@UnknownKeyFor @NonNull @Initialized CodecFactory codec) {
            return new Write<T>(this.inner.withCodec(codec));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDatumWriterFactory(@UnknownKeyFor @NonNull @Initialized AvroSink.DatumWriterFactory<T> datumWriterFactory) {
            return new Write<T>(this.inner.withDatumWriterFactory(datumWriterFactory));
        }

        public <DestinationT> @UnknownKeyFor @NonNull @Initialized TypedWrite<T, DestinationT, T> withOutputFilenames() {
            return this.inner;
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMetadata(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata) {
            return new Write<T>(this.inner.withMetadata(metadata));
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            input.apply(this.inner);
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }
    }

    @AutoValue
    public static abstract class TypedWrite<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>> {
        static final @UnknownKeyFor @NonNull @Initialized CodecFactory DEFAULT_CODEC = CodecFactory.snappyCodec();
        static final @UnknownKeyFor @NonNull @Initialized SerializableAvroCodecFactory DEFAULT_SERIALIZABLE_CODEC = new SerializableAvroCodecFactory(DEFAULT_CODEC);

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, OutputT> getFormatFunction();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> getFilenamePrefix();

        abstract @Nullable @UnknownKeyFor @Initialized String getShardTemplate();

        abstract @Nullable @UnknownKeyFor @Initialized String getFilenameSuffix();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> getTempDirectory();

        abstract @UnknownKeyFor @NonNull @Initialized int getNumShards();

        abstract @UnknownKeyFor @NonNull @Initialized Class<OutputT> getRecordClass();

        abstract @UnknownKeyFor @NonNull @Initialized int getSyncInterval();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getSchema();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getWindowedWrites();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getNoSpilling();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized FileBasedSink.FilenamePolicy getFilenamePolicy();

        abstract @Nullable @UnknownKeyFor @Initialized DynamicAvroDestinations<UserT, DestinationT, OutputT> getDynamicDestinations();

        abstract @Nullable @UnknownKeyFor @Initialized AvroSink.DatumWriterFactory<OutputT> getDatumWriterFactory();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getBadRecordErrorHandler();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableAvroCodecFactory getCodec();

        abstract @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getMetadata();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> to(@UnknownKeyFor @NonNull @Initialized String outputPrefix) {
            return this.to(FileBasedSink.convertToFileResourceIfPossible((String)outputPrefix));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> to(@UnknownKeyFor @NonNull @Initialized ResourceId outputPrefix) {
            return this.toResource((ValueProvider<ResourceId>)ValueProvider.StaticValueProvider.of((Object)outputPrefix));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> outputPrefix) {
            return this.toResource((ValueProvider<ResourceId>)ValueProvider.NestedValueProvider.of(outputPrefix, (SerializableFunction)new OutputPrefixToResourceId()));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> toResource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> outputPrefix) {
            return this.toBuilder().setFilenamePrefix(outputPrefix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> to(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy) {
            return this.toBuilder().setFilenamePolicy(filenamePolicy).build();
        }

        @Deprecated
        public <NewDestinationT> @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, NewDestinationT, OutputT> to(@UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, NewDestinationT, OutputT> dynamicDestinations) {
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withSyncInterval(@UnknownKeyFor @NonNull @Initialized int syncInterval) {
            return this.toBuilder().setSyncInterval(syncInterval).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return this.toBuilder().setSchema(schema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withFormatFunction(@Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> tempDirectory) {
            return this.toBuilder().setTempDirectory(tempDirectory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory) {
            return this.withTempDirectory((ValueProvider<ResourceId>)ValueProvider.StaticValueProvider.of((Object)tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withShardNameTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return this.toBuilder().setShardTemplate(shardTemplate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withSuffix(@UnknownKeyFor @NonNull @Initialized String filenameSuffix) {
            return this.toBuilder().setFilenameSuffix(filenameSuffix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
            Preconditions.checkArgument((numShards >= 0 ? 1 : 0) != 0);
            return this.toBuilder().setNumShards(numShards).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withoutSharding() {
            return this.withNumShards(1).withShardNameTemplate("");
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withWindowedWrites() {
            return this.toBuilder().setWindowedWrites(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withCodec(@UnknownKeyFor @NonNull @Initialized CodecFactory codec) {
            return this.toBuilder().setCodec(new SerializableAvroCodecFactory(codec)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withDatumWriterFactory(@UnknownKeyFor @NonNull @Initialized AvroSink.DatumWriterFactory<OutputT> datumWriterFactory) {
            return this.toBuilder().setDatumWriterFactory(datumWriterFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withMetadata(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> metadata) {
            LinkedHashMap badKeys = Maps.newLinkedHashMap();
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String || v instanceof Long || v instanceof byte[]) continue;
                badKeys.put(entry.getKey(), v.getClass().getSimpleName());
            }
            Preconditions.checkArgument((boolean)badKeys.isEmpty(), (String)"Metadata value type must be one of String, Long, or byte[]. Found %s", (Object)badKeys);
            return this.toBuilder().setMetadata((ImmutableMap<String, Object>)ImmutableMap.copyOf(metadata)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> withBadRecordErrorHandler(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> errorHandler) {
            return this.toBuilder().setBadRecordErrorHandler(errorHandler).build();
        }

        @UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, DestinationT, OutputT> resolveDynamicDestinations() {
            DynamicAvroDestinations<UserT, Object, OutputT> dynamicDestinations = this.getDynamicDestinations();
            if (dynamicDestinations == null) {
                FileBasedSink.FilenamePolicy usedFilenamePolicy = this.getFilenamePolicy();
                if (usedFilenamePolicy == null) {
                    usedFilenamePolicy = DefaultFilenamePolicy.fromStandardParameters(this.getFilenamePrefix(), (String)this.getShardTemplate(), (String)this.getFilenameSuffix(), (boolean)this.getWindowedWrites());
                }
                dynamicDestinations = AvroIO.constantDestinations(usedFilenamePolicy, this.getSchema(), this.getMetadata(), this.getCodec().getCodec(), this.getFormatFunction(), this.getDatumWriterFactory());
            }
            return dynamicDestinations;
        }

        public @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            Preconditions.checkArgument((this.getFilenamePrefix() != null || this.getTempDirectory() != null ? 1 : 0) != 0, (Object)"Need to set either the filename prefix or the tempDirectory of a AvroIO.Write transform.");
            if (this.getFilenamePolicy() != null) {
                Preconditions.checkArgument((this.getShardTemplate() == null && this.getFilenameSuffix() == null ? 1 : 0) != 0, (Object)"shardTemplate and filenameSuffix should only be used with the default filename policy");
            }
            if (this.getDynamicDestinations() != null) {
                Preconditions.checkArgument((this.getFormatFunction() == null ? 1 : 0) != 0, (Object)"A format function should not be specified with DynamicDestinations. Use DynamicDestinations.formatRecord instead");
            } else {
                Preconditions.checkArgument((this.getSchema() != null ? 1 : 0) != 0, (Object)"Unless using DynamicDestinations, .withSchema() is required.");
            }
            ValueProvider<ResourceId> tempDirectory = this.getTempDirectory();
            if (tempDirectory == null) {
                tempDirectory = this.getFilenamePrefix();
            }
            WriteFiles write = WriteFiles.to(new AvroSink<UserT, DestinationT, OutputT>(this.getRecordClass(), tempDirectory, this.resolveDynamicDestinations(), this.getSyncInterval()));
            if (this.getNumShards() > 0) {
                write = write.withNumShards(this.getNumShards());
            }
            if (this.getWindowedWrites()) {
                write = write.withWindowedWrites();
            }
            if (this.getNoSpilling()) {
                write = write.withNoSpilling();
            }
            if (this.getBadRecordErrorHandler() != null) {
                write = write.withBadRecordErrorHandler(this.getBadRecordErrorHandler());
            }
            return (WriteFilesResult)input.apply("Write", (PTransform)write);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.resolveDynamicDestinations().populateDisplayData(builder);
            builder.addIfNotDefault(DisplayData.item((String)"numShards", (Integer)this.getNumShards()).withLabel("Maximum Output Shards"), (Object)0).addIfNotNull(DisplayData.item((String)"tempDirectory", this.getTempDirectory()).withLabel("Directory for temporary files"));
        }

        private static class OutputPrefixToResourceId
        implements SerializableFunction<String, ResourceId> {
            private OutputPrefixToResourceId() {
            }

            public @UnknownKeyFor @NonNull @Initialized ResourceId apply(@UnknownKeyFor @NonNull @Initialized String input) {
                return FileBasedSink.convertToFileResourceIfPossible((String)input);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setFormatFunction(@Nullable @UnknownKeyFor @Initialized SerializableFunction<UserT, OutputT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setFilenamePrefix(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setFilenameSuffix(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setNumShards(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setShardTemplate(@Nullable @UnknownKeyFor @Initialized String var1);

            @Deprecated
            public @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setGenericRecords(@UnknownKeyFor @NonNull @Initialized boolean genericRecords) {
                Class recordClass = genericRecords ? GenericRecord.class : Object.class;
                return this.setRecordClass(recordClass);
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<OutputT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setSyncInterval(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setWindowedWrites(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setNoSpilling(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setFilenamePolicy(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setCodec(@UnknownKeyFor @NonNull @Initialized SerializableAvroCodecFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setMetadata(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setDynamicDestinations(@UnknownKeyFor @NonNull @Initialized DynamicAvroDestinations<UserT, DestinationT, OutputT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setDatumWriterFactory(@UnknownKeyFor @NonNull @Initialized AvroSink.DatumWriterFactory<OutputT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setBadRecordErrorHandler(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Nullable @UnknownKeyFor @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized TypedWrite<UserT, DestinationT, OutputT> build();
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class ParseAll<@UnknownKeyFor T>
    extends PTransform<PCollection<String>, PCollection<T>> {
        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> getParseFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized long getDesiredBundleSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ParseAll<T> withMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseAll<T> withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized ParseAll<T> watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition, matchUpdatedFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized ParseAll<T> watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.watchForNewFiles(pollInterval, terminationCondition, false);
        }

        public @UnknownKeyFor @NonNull @Initialized ParseAll<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseAll<T> withDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return (PCollection)((PCollection)((PCollection)input.apply((PTransform)FileIO.matchAll().withConfiguration(this.getMatchConfiguration()))).apply((PTransform)FileIO.readMatches().withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT))).apply("Parse all via FileBasedSource", AvroIO.parseFilesGenericRecords(this.getParseFn()).withCoder(this.getCoder()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"parseFn", this.getParseFn().getClass()).withLabel("Parse function")).include("matchConfiguration", (HasDisplayData)this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized ParseAll<T> build();
        }
    }

    @AutoValue
    public static abstract class ParseFiles<@UnknownKeyFor T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> getParseFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getUsesReshuffle();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler getFileExceptionHandler();

        abstract @UnknownKeyFor @NonNull @Initialized long getDesiredBundleSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ParseFiles<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles<T> withUsesReshuffle(@UnknownKeyFor @NonNull @Initialized boolean usesReshuffle) {
            return this.toBuilder().setUsesReshuffle(usesReshuffle).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles<T> withFileExceptionHandler(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler exceptionHandler) {
            return this.toBuilder().setFileExceptionHandler(exceptionHandler).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ParseFiles<T> withDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            Coder coder = Parse.inferCoder(this.getCoder(), this.getParseFn(), input.getPipeline().getCoderRegistry());
            SerializableFunction<GenericRecord, T> parseFn = this.getParseFn();
            CreateParseSourceFn<T> createSource = new CreateParseSourceFn<T>(parseFn, coder);
            return (PCollection)input.apply("Parse Files via FileBasedSource", (PTransform)new ReadAllViaFileBasedSource(this.getDesiredBundleSizeBytes(), createSource, coder, this.getUsesReshuffle(), this.getFileExceptionHandler()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"parseFn", this.getParseFn().getClass()).withLabel("Parse function"));
        }

        private static class CreateParseSourceFn<@UnknownKeyFor T>
        implements SerializableFunction<String, FileBasedSource<T>> {
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn;
            private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

            CreateParseSourceFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
                this.parseFn = parseFn;
                this.coder = coder;
            }

            public @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> apply(@UnknownKeyFor @NonNull @Initialized String input) {
                return AvroSource.from(input).withParseFn(this.parseFn, this.coder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsesReshuffle(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFileExceptionHandler(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized ParseFiles<T> build();
        }
    }

    @AutoValue
    public static abstract class Parse<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> getParseFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getHintMatchesManyFiles();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Parse<T> from(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> withMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Parse<T> withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (Object)"filepattern");
            Coder<T> coder = Parse.inferCoder(this.getCoder(), this.getParseFn(), input.getPipeline().getCoderRegistry());
            if (this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles()) {
                return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from(AvroSource.from(this.getFilepattern()).withParseFn(this.getParseFn(), coder)));
            }
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply("Match All", (PTransform)FileIO.matchAll().withConfiguration(this.getMatchConfiguration()))).apply("Read Matches", (PTransform)FileIO.readMatches().withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT))).apply("Via ParseFiles", AvroIO.parseFilesGenericRecords(this.getParseFn()).withCoder(coder));
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> inferCoder(@Nullable @UnknownKeyFor @Initialized Coder<T> explicitCoder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
            if (explicitCoder != null) {
                return explicitCoder;
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(parseFn));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using withCoder().", e);
            }
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern")).add(DisplayData.item((String)"parseFn", this.getParseFn().getClass()).withLabel("Parse function")).include("matchConfiguration", (HasDisplayData)this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized GenericRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setHintMatchesManyFiles(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Parse<T> build();
        }
    }

    private static class CreateSourceFn<@UnknownKeyFor T>
    implements SerializableFunction<String, FileBasedSource<T>> {
        private final @UnknownKeyFor @NonNull @Initialized Class<T> recordClass;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Schema> schemaSupplier;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        private final @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> readerFactory;

        CreateSourceFn(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass, @UnknownKeyFor @NonNull @Initialized String jsonSchema, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> readerFactory) {
            this.recordClass = recordClass;
            this.schemaSupplier = Suppliers.memoize((Supplier)Suppliers.compose((Function)new JsonToSchema(), (Supplier)Suppliers.ofInstance((Object)jsonSchema)));
            this.coder = coder;
            this.readerFactory = readerFactory;
        }

        public @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> apply(@UnknownKeyFor @NonNull @Initialized String input) {
            return Read.createSource((ValueProvider<String>)((ValueProvider)ValueProvider.StaticValueProvider.of((Object)input)), EmptyMatchTreatment.DISALLOW, this.recordClass, (Schema)this.schemaSupplier.get(), this.coder, this.readerFactory);
        }

        private static class JsonToSchema
        implements Function<String, Schema>,
        Serializable {
            private JsonToSchema() {
            }

            public @UnknownKeyFor @NonNull @Initialized Schema apply(@UnknownKeyFor @NonNull @Initialized String input) {
                return new Schema.Parser().parse(input);
            }
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class ReadAll<@UnknownKeyFor T>
    extends PTransform<PCollection<String>, PCollection<T>> {
        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getSchema();

        abstract @UnknownKeyFor @NonNull @Initialized long getDesiredBundleSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getInferBeamSchema();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadAll<T> withMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll<T> withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll<T> watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll<T> withDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll<T> withBeamSchemas(@UnknownKeyFor @NonNull @Initialized boolean withBeamSchemas) {
            return this.toBuilder().setInferBeamSchema(withBeamSchemas).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            Preconditions.checkNotNull((Object)this.getSchema(), (Object)"schema");
            PCollection read = (PCollection)((PCollection)((PCollection)input.apply((PTransform)FileIO.matchAll().withConfiguration(this.getMatchConfiguration()))).apply((PTransform)FileIO.readMatches().withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT))).apply(AvroIO.readFiles(this.getRecordClass()));
            return this.getInferBeamSchema() ? AvroIO.setBeamSchema(read, this.getRecordClass(), this.getSchema()) : read;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"inferBeamSchema", (Boolean)this.getInferBeamSchema()).withLabel("Infer Beam Schema")).addIfNotNull(DisplayData.item((String)"schema", (String)String.valueOf(this.getSchema()))).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("Record Class")).include("matchConfiguration", (HasDisplayData)this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setInferBeamSchema(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadAll<T> build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles<@UnknownKeyFor T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getSchema();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getUsesReshuffle();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler getFileExceptionHandler();

        abstract @UnknownKeyFor @NonNull @Initialized long getDesiredBundleSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getInferBeamSchema();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @Nullable @UnknownKeyFor @Initialized AvroSource.DatumReaderFactory<T> getDatumReaderFactory();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withUsesReshuffle(@UnknownKeyFor @NonNull @Initialized boolean usesReshuffle) {
            return this.toBuilder().setUsesReshuffle(usesReshuffle).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withFileExceptionHandler(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler exceptionHandler) {
            return this.toBuilder().setFileExceptionHandler(exceptionHandler).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withBeamSchemas(@UnknownKeyFor @NonNull @Initialized boolean withBeamSchemas) {
            return this.toBuilder().setInferBeamSchema(withBeamSchemas).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withDatumReaderFactory(@UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> factory) {
            return this.toBuilder().setDatumReaderFactory(factory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            Preconditions.checkNotNull((Object)this.getSchema(), (Object)"schema");
            Coder coder = (Coder)Optional.ofNullable(this.getCoder()).orElse((Coder<AvroCoder<T>>)AvroCoder.of(this.getRecordClass(), this.getSchema()));
            PCollection read = (PCollection)input.apply("Read all via FileBasedSource", (PTransform)new ReadAllViaFileBasedSource(this.getDesiredBundleSizeBytes(), new CreateSourceFn<T>(this.getRecordClass(), this.getSchema().toString(), coder, this.getDatumReaderFactory()), coder, this.getUsesReshuffle(), this.getFileExceptionHandler()));
            return this.getInferBeamSchema() ? AvroIO.setBeamSchema(read, this.getRecordClass(), this.getSchema()) : read;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"inferBeamSchema", (Boolean)this.getInferBeamSchema()).withLabel("Infer Beam Schema")).addIfNotNull(DisplayData.item((String)"schema", (String)String.valueOf(this.getSchema()))).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("Record Class"));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsesReshuffle(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFileExceptionHandler(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDesiredBundleSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setInferBeamSchema(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDatumReaderFactory(@UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration getMatchConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized Schema getSchema();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getInferBeamSchema();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getHintMatchesManyFiles();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @Nullable @UnknownKeyFor @Initialized AvroSource.DatumReaderFactory<T> getDatumReaderFactory();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> from(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration matchConfiguration) {
            return this.toBuilder().setMatchConfiguration(matchConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition, matchUpdatedFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> watchForNewFiles(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.watchForNewFiles(pollInterval, terminationCondition, false);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withBeamSchemas(@UnknownKeyFor @NonNull @Initialized boolean withBeamSchemas) {
            return this.toBuilder().setInferBeamSchema(withBeamSchemas).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDatumReaderFactory(@UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> readerFactory) {
            return this.toBuilder().setDatumReaderFactory(readerFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (Object)"filepattern");
            Preconditions.checkNotNull((Object)this.getSchema(), (Object)"schema");
            if (this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles()) {
                PCollection read = (PCollection)input.apply("Read", (PTransform)org.apache.beam.sdk.io.Read.from(Read.createSource(this.getFilepattern(), this.getMatchConfiguration().getEmptyMatchTreatment(), this.getRecordClass(), this.getSchema(), this.getCoder(), this.getDatumReaderFactory())));
                return this.getInferBeamSchema() ? AvroIO.setBeamSchema(read, this.getRecordClass(), this.getSchema()) : read;
            }
            ReadFiles<Object> readFiles = this.getRecordClass() == GenericRecord.class ? AvroIO.readFilesGenericRecords(this.getSchema()) : AvroIO.readFiles(this.getRecordClass());
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply("Match All", (PTransform)FileIO.matchAll().withConfiguration(this.getMatchConfiguration()))).apply("Read Matches", (PTransform)FileIO.readMatches().withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT))).apply("Via ReadFiles", readFiles.withDatumReaderFactory(this.getDatumReaderFactory()).withCoder(this.getCoder()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"inferBeamSchema", (Boolean)this.getInferBeamSchema()).withLabel("Infer Beam Schema")).addIfNotNull(DisplayData.item((String)"schema", (String)String.valueOf(this.getSchema()))).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("Record Class")).addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern")).include("matchConfiguration", (HasDisplayData)this.getMatchConfiguration());
        }

        private static <T> @UnknownKeyFor @NonNull @Initialized AvroSource<T> createSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized Class<T> recordClass, @UnknownKeyFor @NonNull @Initialized Schema schema, @Nullable @UnknownKeyFor @Initialized Coder<T> coder, @Nullable @UnknownKeyFor @Initialized AvroSource.DatumReaderFactory<T> readerFactory) {
            AvroSource<Object> source;
            AvroSource<GenericRecord> base = AvroSource.from(filepattern).withEmptyMatchTreatment(emptyMatchTreatment);
            AvroSource<Object> avroSource = source = recordClass == GenericRecord.class ? base.withSchema(schema) : base.withSchema(recordClass);
            if (readerFactory != null) {
                source = source.withDatumReaderFactory(readerFactory);
            }
            if (coder != null) {
                source = source.withCoder(coder);
            }
            return source;
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMatchConfiguration(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileIO.MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setInferBeamSchema(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setHintMatchesManyFiles(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDatumReaderFactory(@UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }
}

