/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] iterators;
    private int counter = 0;
    private T currentNext;

    public CompositeIterator(Iterator<T> ... iterators) {
        this.iterators = iterators;
        this.currentNext = this.internalNext();
    }

    @Override
    public boolean hasNext() {
        return this.currentNext != null;
    }

    @Override
    public T next() {
        if (this.currentNext == null) {
            throw new NoSuchElementException();
        }
        T result = this.currentNext;
        this.currentNext = this.internalNext();
        return result;
    }

    private T internalNext() {
        while (this.counter < this.iterators.length) {
            if (this.iterators[this.counter].hasNext()) {
                return this.iterators[this.counter].next();
            }
            ++this.counter;
        }
        return null;
    }
}

